/**
 * jQuery Plugins for Shopware 3.5 Storefront
 * http://shopware.de
 *
 *
 * DISCLAIMER
 *
 * Do not edit this file if you wish to upgrade
 * Shopware to newer versions in the future. If
 * you wish to customize Shopware for your needs
 * please refer to http://www.shopware.de/wiki
 * for more informations.
 *
 * @package		default
 * @subpackage	javascript
 * @category	design
 * version		v1.9
 * @author		stp/shopware AG <info@shopware.de>
 * @copyright	Copyright (c) 2010 Shopware AG (http://www.shopware.de)
 *
 * CHANGELOG
 * Version 1.9
 * - removed unnecessary CSS styling
 *
 * Version 1.8
 * - added ajax slider component
 * - loading indicator plugin
 *
 * Version 1.7
 * - added OnePage checkout
 * - liveshopping plugin
 * - check notifcation
 * - bundle plugin
 * - refactoring livesearch
 *
 * Version 1.6
 * - added modal window plugin
 * - added ajax basket plugin
 * - onepage checkout
 * - compressed plugins
 *
 * Version 1.5
 * - inital release
 * - changing listing view
 * - replace fancybox with an enhanced version of slimbox
 * - replace jqzoom with an enhanced version of cloudzoom
 * - completely rewritten topseller accordion
 * - added slideable properties filters
 * - serveral improvements
 * - added jquery ui and jquery tabs
 *
 * Version 1.4
 * - bugfix release
 * - added cross-browser support
 *
 * Version 1.3
 * - added utilities, fancybox and jqzoom
 * - fixes serval bugs in the compare plugin
 *
 * Version 1.2
 * - added search and compare
 *
 * Version 1.1
 * - bugfix release
 *
 * Version 1.0
 * - inital release
 */
jQuery(document).ready(function ($) {

    // Removes hiding class for all script related elements
    $('.hide_script').removeClass('hide_script');

    //IE 6 Drop down menu fallback
    if ($.browser.msie === true && parseInt($.browser.version, 10) === 6) {
        $('#mainNavigation li').hover(function () {
            $(this).addClass('hover');
        }, function () {
            $(this).removeClass('hover');
        });
    }

    //Liveshopping
    $('.liveshopping_container:visible, .liveshopping_detail:visible').liveshopping();

    //Bundle
    $('.bundle_container, .relatedbox_container').bundle();

    //Checkout
    $('a.checkout, a.login, a.account').checkout({
        'viewport': $.controller.ajax_login,
        'register': $.controller.register,
        'checkout': $.controller.checkout
    });

    //Supplier filter
    $('.supplier_filter .slideContainer').supplierfilter();

    //AJAX Warenkorb
    $.basket.options.viewport = $.controller.ajax_cart;
    $.basket.init();

    $('select.auto_submit').bind('change', function () {
        this.form.submit();
    });
    $('input.auto_submit:radio, a.auto_submit, input.auto_submit:checkbox').live('click', function () {
        this.form.submit();
    });
    $('input.auto_submit:text').live('blur', function () {
        this.form.submit();
    });

    $('.modal_close').live('click', function () {
        $.modalClose();
        $.ie6fix.selectShow();
    });

    $('.modal_open a').click(function (event) {
        event.preventDefault();

        $.ajax({
            type: 'post',
            url: this.href,
            data: {
                isXHR: 1
            },
            success: function (data) {
                $.modal(data, '', {
                    'position': 'fixed'
                }).find('.close').remove();
            }
        })
    });

    //Topseller
    if ($('.topseller')) {
        $('.accordion').kwicks({
            min: 52,
            sticky: true,
            spacing: 0,
            isVertical: true,
            duration: 350
        });
    }

    //Suggest Search
    $('#searchfield').liveSearch({
        url: $.controller.ajax_search,
        'id': 'searchresults'
    });
    var defaultValue = $('#searchfield').val();
    $('#searchfield').focus(function () {
        if ($('#searchfield').val() === defaultValue) {
            $('#searchfield').val('');
        }
    });

    //Get's the servertime for liveshopping articles
    $.server.init(timeNow);

//    Changing article informations on variants
    if (typeof (isVariant) !== 'undefined' && isVariant === true && isConfigurator !== true) {
        $.changeDetails(0);
    }
    $('#sAdd.variant').change(function () {
        $.changeDetails($(this).val());
    });

    //Lightbox basket
    $('a.zoom_picture[rel^=lightbox]').slimbox();

    //AJAX basket
    $('div.ajax_basket').click(function () {
        if ($('.ajax_basket_result').hasClass('active')) {
            $('.ajax_basket_result').removeClass('active').slideToggle('fast');
        } else {
            $.basket.getBasket();
        }
    });

    //Article detail accessory
    var lasthover;
    $('.basketform label').hover(function () {
        var $this = $(this);

        var value = $this.prev('input').val();

        if (value && value.length) {
            $('div#DIV' + value).fadeIn('fast');
            lasthover = $('div#DIV' + value);
        }
    }, function () {
        if(!lasthover) {
            return false;
        }
        lasthover.fadeOut('fast');
        lasthover = '';
    });

    //Article detail accessory
    $('.accessory_group input').bind('change', function () {
        var $this = $(this);
        $accessories = $('#sAddAccessories');
        $accessories.val('');
        if ($this.is(':checked')) {

            $('.accessory_group input:checked').each(function (i, el) {
                var val = $accessories.val();
                val += $(el).val() + ';';
                $accessories.val(val);
            });
        }
    });

    //Lightbox - Blog
    $('.blogbox [rel^=lightbox]').slimbox();

    //Use a lightbox instead of a zoom
    if (typeof (useZoom) !== 'undefined' && (useZoom === '0' || useZoom === '')) {
        $("[rel^='lightbox']").slimbox();
        $('div.thumb_box a').bind('click', function (event) {
            event.preventDefault();
            $('a#zoom1').hide().attr('href', $(this).attr('href')).children().attr('src', $(this).attr('rev'));
            $('a#zoom1').fadeIn('slow');
            return false;
        });
    }

    $('.account .password').hide();
    $('.account .email').hide();

    //Change password account
    if ($('.account .password').hasClass('displayblock')) {
        $('.account .password').show();
    }
    if ($('.account .email').hasClass('displayblock')) {
        $('.account .password').show();
    }

    $('.account .change_password').bind('click', function (event) {
        event.preventDefault();
        $('.account .password').slideToggle('fast').toggleClass('active');
        $('.account .email').slideUp('fast');
    });

    //Change email account
    $('.account .change_mail').bind('click', function (event) {
        event.preventDefault();
        $('.account .email').slideToggle('fast').toggleClass('active');
        $('.account .password').slideUp('fast');
    });

    //Logout Account
    $('.logout').bind('click', function (event) {
        event.preventDefault();
        $.post($.controller.ajax_logout, function (data) {
            var position = 'fixed';
            if ($.browser.msie && parseInt($.browser.version, 10) === 6) {
                position = 'absolute';
            }
            $.modal(data, '', {
                'position': position
            }).find('.close').remove();
            if ($.browser.msie && ~~$.browser.version <= 7) {
                buttons = $('.modal').find('.button-right');
                buttons.each(function () {
                    this.fireEvent('onmove');
                });
            }
        });
    });

    //User account page orders
    $('.orderoverview_active .orderdetails').bind('click', function (e) {
        e.preventDefault();
        if ($('#' + $(this).attr('rel')).hasClass('active')) {
            $('#' + $(this).attr('rel')).removeClass('active').hide();
        } else {
            $('#' + $(this).attr('rel')).addClass('active').show();
        }
    });

    //Register validation
    $('.register .required:input').validate();

    if ($("#register_personal_customer_type").val() === "private") {
        $('.register .company_informations').hide();
    }

    if ($("#register_personal_skipLogin").is(':checked')) {
        $('.register .fade_password, .register p.description').hide();
    }

    $("#register_personal_customer_type").change(function () {
        if ($(this).val() === 'business') {
            $('.register .company_informations').slideDown();
        } else {
            $('.register .company_informations').slideUp();
        }
    });

    if (!$("#register_billing_shippingAddress").is(':checked')) {
        if (!$('.register').hasClass('change_shipping')) {
            $('.register .alternative_shipping').hide();
        }
    }

    $('#register_billing_shippingAddress').click(function () {
        if (!$(this).is(':checked')) {
            $('.register .alternative_shipping').slideUp();
        } else {
            $('.register .alternative_shipping').slideDown();
        }
    });

    $('#register_personal_skipLogin').click(function () {
        if ($(this).is(':checked')) {
            $('.register .fade_password, .register p.description').slideUp();
        } else {
            $('.register .fade_password, .register p.description').slideDown();
        }
    });

    // Loading Indicator
    $('form.upprice_config').bind('change', function () {
        $.loadingIndicator.open();
    });


    /**
     * Account partner statistic
     */
    $('.datePicker').datepicker({
        showOn: "button",
        buttonImage: "../templates/_emotion/frontend/_resources/images/calendar.gif",
        dateFormat: 'dd.mm.yy',
        buttonImageOnly: true,
        onSelect: function (dateText, inst) {
            $(this).parents('form').submit();
        }
    });

    $("div.captcha-placeholder[data-src]").each(function() {
        var $this = $(this),
            requestURL = $this.attr('data-src') || '',
            $window = $(window);

        if (!requestURL || !requestURL.length) {
            return false;
        }

        // fix bfcache from caching the captcha/whole rendered page
        $window.unload(function(){ });
        $window.on('pageshow', function (event) {
            if (event.originalEvent.persisted) {
                $.ajax({
                    url: requestURL,
                    cache: false,
                    success: $this.html.bind($this)
                });
            }
        });

        $.ajax({
            url: requestURL,
            cache: false,
            success: $this.html.bind($this)
        });
    });
});

/**
 * Shopware Device Cookie
 */
(function($, window, document) {

    var $window = $(window),
        devices = {
        'mobile': {
            start: 0,
            end: 767
        },
        'tablet': {
            start: 768,
            end: 1259
        },
        'desktop': {
            start: 1260,
            end: 5160
        }
    };

    function getViewportWidth() {
        var width = window.innerWidth;

        if (typeof width === 'number') {
            return width;
        }

        return (width = document.documentElement.clientWidth) !== 0 ? width : document.body.clientWidth;
    }

    function getCurrentDevice(viewportWidth) {
        var width = viewportWidth || getViewportWidth(),
            currentDevice = 'desktop';

        $.each(devices, function(key, value) {
            if (width > value.start && width < value.end) {
                currentDevice = key;
            }
        });

        return currentDevice;
    }

    function setDeviceCookie() {
        device = getCurrentDevice();

        document.cookie = 'x-ua-device=' + device + '; path=/';
    }

    $(document).ready(function() {

        setDeviceCookie();

        $window.bind('resize', function() {
            setDeviceCookie();
        });
    });
})(jQuery, window, document);

/**
 * Shopware Button Solution
 *
 * Shopware AG (c) 2012
 */
(function($) {
    $(document).ready(function() {
        $('.agb_accept input[name=sAGB]').change(function() {
            $('.agb-checkbox').val($(this).is(':checked') ? 1 : 0);
        });

        $('textarea[name=sComment]').change(function() {
            $('.comment-textarea').val($(this).val());
        });
    });
})(jQuery);

/**
 * Shopware Registration
 *
 * Shopware AG (c) 2012
 */
(function($) {

    $(document).ready(function() {

        $('.register #country').bind('change', function() {
            var $this = $(this), selected = $this.find(':selected'), val = selected.val();

            // Reset all visible selection boxes if the value is empty (e.g. Please select...)
            $('.register .shipping_address .country-area-state-selection select').attr('disabled', 'disabled');
            $('.register .shipping_address .country-area-state-selection select').parents('div.selection').addClass('hidden');

            var id = $.format('#country_%0_states', ~~(1* val));
            $('.register .shipping_address select'+ id ).removeAttr('disabled').parents('div.selection').removeClass('hidden');
        });

        $('.register #country2').bind('change', function() {
            var $this = $(this), selected = $this.find(':selected'), val = selected.val();

            // Reset all visible selection boxes if the value is empty (e.g. Please select...)
            $('.register .alternative_shipping .country-area-state-selection select').attr('disabled', 'disabled');
            $('.register .alternative_shipping .country-area-state-selection select').parents('div.selection').addClass('hidden');


            var id = $.format('#country_%0_states', ~~(1* val));
            $('.register .alternative_shipping select'+ id ).removeAttr('disabled').parents('div.selection').removeClass('hidden');
        });

        if($.controller.vat_check_required){
            var snippetElement = $('label[for=register_billing_ustid] span.frontend_register_billing_fieldset');
            var labelElement = $('label[for=register_billing_ustid]');
            var text = snippetElement.text();
            snippetElement.text(text + '*');
            labelElement.removeClass('normal');
        }
    });
})(jQuery);

/**
 * AJAX Validation
 * for Shopware
 *
 * Shopware AG (c) 2011
 */

/**
 * AJAX Validation
 * for Shopware
 *
 * Shopware AG (c) 2011
 */ (function ($) {

    /** Plugin starter */
    $(document).ready(function () {
        $('.account .password :input').accountValidation();
        $('.account .email input').accountValidation();
    });

    /**
     * Shopware UI - Account validation
     *
     * This jQuery plugin checks the given
     * mail address and the given password
     * against our criterions. Additionally we're
     * checking the mail address against the server side
     * to avoid account hijacking
     *
     * Example usage:
     * $('[selector]').accountValidation([settings]);
     *
     * @param {obj} settings - user settings
     * @return {obj} jQuery object basend on the given selector
     */
    $.fn.accountValidation = function (settings) {

        /** Extend the default configuration with the provided user settings */
        if (settings) {
            $.extend($.accountValidation.config, settings);
        }

        /** Return this for jQuery's chaining support */
        return this.each(function () {
            var $me = $(this);

            /** Disable the submit button */
            if (!$.browser.msie && parseInt($.browser.version, 10) !== 6) {
                $me.parents('form').find('input[type=submit]').attr('disabled', 'disabled').css('opacity', 0.5);
            }

            /** Event listener which checks on every keystroke the password and it's iteration */
            $me.bind('keyup', function () {
                if ($me.attr('id') === 'newpwdrepeat' && $me.val().length === $('#newpwd').val().length) {
                    $me.triggerHandler('blur');
                }
                if ($me.attr('id') === 'newmailrepeat' && $me.val().length === $('#newmail').val().length) {
                    $me.triggerHandler('blur');
                }
            });

            /** Event listener which checks the given mail addresses or the given password against the server side */
            $me.bind('blur', function () {
                var error = false;

                if (!$me.val().length) {
                    error = true;
                }

                if (($me.attr('id') === 'newpwd' || $me.attr('id') === 'newpwdrepeat') && !error) {
                    $.accountValidation.checkPasswd($me);
                }

                if (($me.attr('id') === 'neweailrepeat' || $me.attr('id') === 'newmail') && !error) {
                    $.accountValidation.checkEmail($me);
                }
            });
        });
    };

    $.accountValidation = {

        /** Default configuration */
        config: {
            errorCls: 'instyle_error',
            successCls: 'instyle_success'
        },

        /**
         * Simple method which sets the configured error class to the given element
         *
         * @param {obj} $el - jQuery object of the element which will become invalid
         * @return {obj} $el - jQuery object of the passed element
         */
        setError: function ($el) {
            $el.removeClass($.accountValidation.config.successCls).addClass($.accountValidation.config.errorCls);

            return $el;
        },

        /**
         * Simple method which sets the configured success class to the given element
         *
         * @param {obj} $el - jQuery object of the element which will become valid
         * @return {obj} $el - jQuery object of the passed element
         */
        setSuccess: function ($el) {
            $el.removeClass($.accountValidation.config.errorCls).addClass($.accountValidation.config.successCls);

            return $el;
        },

        /**
         * Validates the password
         *
         * @param {obj} object of the repeat field
         * @return void
         */
        checkPasswd: function ($repeat) {
            var $form = $repeat.parents('form');

            var str = '';

            $form.find('input[type=password]').each(function (i, el) {
                var $el = $(el),
                        name = $el.attr('name');

                if (str.length) {
                    str += '&';
                }
                str += 'register[personal][' + name + ']=' + $el.val();
            });

            str = encodeURI(str);

            $.accountValidation.ajaxValidation('ajax_validate_password', str, $form);
        },

        /**
         * Validates the email address
         *
         * @param {obj} object of the repeat field
         * @return void
         */
        checkEmail: function ($repeat) {
            var $form = $repeat.parents('form');

            var str = '';
            $form.find('input[type=text]').each(function (i, el) {
                var $el = $(el),
                        name = $el.attr('name');

                if (str.length) {
                    str += '&';
                }
                str += 'register[personal][' + name + ']=' + $el.val();
            });

            str = encodeURI(str);

            $.accountValidation.ajaxValidation('ajax_validate_email', str, $form);
        },

        /**
         * Validates the given elements against the server side
         * and determines on the base of the request response
         * if the given elements are valid or invalid.
         *
         * @param {str} action - the action which will be called server side
         * @param {str} data - the data string which will be send to the server
         * @param {obj} $form - jQuery object of the form
         * @return void
         */
        ajaxValidation: function (action, data, $form) {

            $.ajax({
                'data': data,
                'type': 'post',
                'dataType': 'json',
                'url': $.controller.ajax_validate + '?action=' + action,
                'success': function (result) {

                    $.each(result.error_flags, function (key, val) {
                        if (val) {
                            $.accountValidation.setError($('input[name=' + key + ']'));
                        } else {
                            $.accountValidation.setSuccess($('input[name=' + key + ']'));
                        }
                    });

                    if (!result.success) {

                        if (!$.isEmptyObject(result.error_flags)) {

                            $(document.body).find('#ajax-validate-error').remove();

                            // Get first element in form
                            var first = $form.find('input:first');

                            // Output error message
                            var err = $('<div>', {
                                'class': 'error',
                                'id': 'ajax-validate-error',
                                'html': result.error_messages[0],
                                'css': {
                                    'display': 'none',
                                    'position': 'absolute',
                                    'top': first.offset().top,
                                    'left': first.offset().left + first.outerWidth() + 30,
                                    'width': 200,
                                    'zIndex': 100
                                }
                            }).prependTo($(document.body)).fadeIn('fast');

                            window.setTimeout(function () {
                                err.remove();
                            }, 4000);

                            // Check for IE6 to prevent a displaying issue
                            if (!$.browser.msie && parseInt($.browser.version, 10) !== 6) {
                                $form.find(':submit').attr('disabled', 'disabled').css('opacity', 0.5);
                            }
                        }
                    } else {

                        $form.find('input[type=password], input[type=text]').each(function (i, el) {
                            $(document.body).find('#ajax-validate-error').remove();

                            // Check for IE6 to prevent a displaying issue
                            if (!$.browser.msie && parseInt($.browser.version, 10) !== 6) {

                                $form.find('input[type=submit]').removeAttr('disabled').css('opacity', 1);
                            }
                        });
                    }
                }
            });
        }
    };
})(jQuery);

/**
 * AJAX Slider
 * for Shopware
 *
 * Shopware AG (c) 2010
 */ (function ($) {

    /**
     * $.fn.ajaxSlider
     *
     * Creates an slider
     *
     * Just call the plugin with the following syntax:
     * $('selector').ajaxSlider('[mode]', { [your_settings] });
     *
     * The called file must have the following structure
     * <div class="slide">
     *     ... [your elements] ...
     * </div>
     *
     * If you're calling this plugin in ajax mode, please
     * consider that this plugin has two kinds of ajax mode.
     *
     * You're getting in the first mode if you're setting
     * the mode to 'ajax' and 'navigation': true. This mode get's
     * all data at the page load and scrolls through the slides.
     * The second modes would be called when you set the mode to
     * 'ajax' and 'navigation': false.
     *
     * @param:  (string) mode  - mode to use
     * @param:  (obj) settings - user settings
     * @return: (obj) this     - selector which was passed to the plugin
     */
    $.fn.ajaxSlider = function (mode, settings) {

        // default plugin config
        var config = {

            // Public
            'layout': 'horizontal',
            'scrollWidth': 711,
            'scrollHeight': 711,
            'scrollSpeed': 400,
            'containerClass': 'ajaxSlider',
            'containerCSS': {},
            'ajaxMethod': 'POST',
            'loadingText': 'Loading...',
            'loadingContainer': 'loader',
            'title': '',
            'titleClass': 'headingbox',
            'headline': false,
            'url': '',
            'rotate': false,
            'rotateSpeed': 5000,
            'navigation': true,
            'navigationClass': 'slide_navigation',
            'showNumbers': false,
            'numberText': 'Seite %0 von %1',
            'debug': false,
            'maxPages': 0,
            'extraParams': {},
            'showArrows': true,
            'minSwipeDistance': 300,
            'swipeRunning': false,

            // Private
            '_this': null,
            '_container': null,
            '_slideContainer': null,
            '_slideOuterContainer': null,
            '_slideContainerWidth': null,
            '_slideContainerHeight': null,
            '_headline': null,
            '_loader': null,
            '_leftArrow': null,
            '_rightArrow': null,
            '_slidesCount': null,
            '_slideNavigation': null,
            '_activeNavigation': null,
            '_activeSlide': null,
            '_rotateInterval': null,
            '_numbers': null,
            '_mode': null
        };

        // Override default config with user settings
        if (settings) {
            $.extend(config, settings);
        }

        this.each(function () {


            // IE 7 & 8 Fix for Object.create($.ajaxSlider)
            if (typeof Object.create !== "function") {
                Object.create = (function () {
                    function F() {} // created only once
                    return function (o) {
                        F.prototype = o; // reused on each invocation
                        return new F();
                    };
                })();
            }

            var slider = Object.create($.ajaxSlider);

            if (config.debug === true) {
                console.group('Slider: .' + $(this).attr('class'));
            }

            slider.debugMode('Mode: ' + mode, config);

            config._this = $(this);
            slider._self = $(this);

            slider.debugMode('Create Container', config);

            // Create slider outer container and replace selector
            config._container = $('<div>', {
                'class': config.containerClass
            }).appendTo(config._this);

            slider.debugMode('Container created', config);

            // Save slider mode
            config._mode = mode;

            // Add layout class
            config._this.addClass(config.layout + '_slider');

            if (config.title !== '' && config.headline) {
                slider.debugMode('Create headline', config);

                // Create headline
                config._headline = $('<h2>', {
                    'class': config.titleClass,
                    'text': config.title
                }).prependTo(config._container);
            }

            slider.debugMode('Create left arrow', config);

            // Left arrow
            config._leftArrow = $('<a>', {
                'class': 'leftArrow',
                'text': 'Slide left',
                'title': 'Slide left',
                'href': '#slideLeft'
            }).appendTo(config._container).hide();

            slider.debugMode('Create right arrow', config);

            // Right arrow
            config._rightArrow = $('<a>', {
                'class': 'rightArrow',
                'text': 'Slide right',
                'title': 'Slide right',
                'href': '#slideRight'
            }).appendTo(config._container).hide();

            if($.ajaxSlider.isiPad || !config.showArrows) {
                config.showArrows = false;
                config._leftArrow.hide();
                config._rightArrow.hide();
            }

            slider.debugMode('Select mode', config);
            slider.setConfig(config);
            slider.config = config;

            // Mode selection
            switch (mode) {
                case 'ajax':
                    slider.ajaxMode(config);
                    break;
                case 'locale':
                    slider.localeMode(config);
                    break;
                default:
                    slider.debugMode('The passed mode is not supported', config);
                    return false;
            }

            if (config.rotate === true) {
                slider.debugMode('Create rotation', config);

                var timeout = window.setTimeout(function() {
                    slider.rotateSlider(config);
                    timeout = null;
                }, 80);

            }
        });

        if (config.debug === true) {
            console.groupEnd();
        }

        // Return this to support jQuery's chaining
        return this;
    };

    $.ajaxSlider = {

        /**
         * Indicates if we're dealing with an iPad
         */
        isiPad: navigator.userAgent.match(/iPad/i) != null,

        /**
         * $.ajaxSlider.setConfig
         *
         * Helper method which sets the configuration object
         * of the ajaxSlider object.
         *
         * @param (obj) config - the plugin config
         */
        setConfig: function(config) {
            this.config = config;
            return true;
        },

        /**
         * $.ajaxSlider.createContainers
         *
         * Creates the needed container for the slider
         *
         * @param:  (obj) config - the plugin config
         */
        createContainers: function (config) {
            // Create sliding outer container
            config._slideOuterContainer = $('<div>', {
                'class': 'sliding_outer'
            }).appendTo(config._container);

            // Create actual sliding container
            config._slideContainer = $('<div>', {
                'class': 'sliding_container'
            }).prependTo(config._slideOuterContainer).hide();
        },

        /**
         * $.ajaxSlider.getPage
         *
         * Requests the given url
         * and handles all ajax related
         * stuff
         *
         * @param:  (string) slideNumber - Number of the slide to load
         * @param:  (obj) config - the plugin config
         */
        getPage: function (slideNumber, config) {

            var requestParams = {
                'pages': slideNumber
            };

            if(config.extraParams) {
                if(!config._articlePerPage) {
                    config._articlePerPage = config.extraParams.limit;
                }

                config.extraParams.start = (slideNumber - 1 ) * config._articlePerPage;
                config.extraParams.limit = config._articlePerPage;

                $.extend(requestParams, config.extraParams);
            }
            $.ajax({
                'url': config.url,
                'method': config.ajaxMethod,
                'data': requestParams,
                'beforeSend': function () {
                    if (config._loader === null) {

                        // Create AJAX Loader
                        config._loader = $('<div>', {
                            'text': config.loadingText,
                            'class': config.loadingContainer
                        }).appendTo(config._container);
                    } else {
                        config._loader.show();
                    }

                    // Find old slide and remove it
                    config._slideContainer.fadeOut().find('.slide').remove();
                },
                'error': function () {
                    // Fadeout loader and hide container on error
                    config._loader.fadeOut('slow');
                    config._container.hide();
                },
                'success': function (result) {
                    if (!result.length) {
                        // If the result is empty, hide container
                        config._loader.fadeOut('slow');
                        config._container.hide();
                        return false;
                    } else {

                        // Calculate where the content should be insert
                        if (slideNumber > config._activeSlide) {
                            $(result).appendTo(config._slideContainer);
                        } else if (slideNumber < config._activeSlide) {
                            $(result).prependTo(config._slideContainer);
                        } else if (slideNumber === config._activeSlide) {
                            config._slideContainer.html(result);
                        }

                        // Remove pages tag
                        var pages = config._slideContainer.find('.pages');
                        if(config.maxPages && config.maxPages >= 1) {
                            config._slidesCount = config.maxPages;
                        } else {
                            config._slidesCount = pages.text();
                        }
                        config._slidesCount = ~~(1*config._slidesCount);
                        pages.remove();

                        //Handling arrows
                        if (slideNumber === 1) {
                            config._leftArrow.hide();
                            config._rightArrow.show();
                        } else if (slideNumber === config._slidesCount) {
                            config._leftArrow.show();
                            config._rightArrow.hide();
                        } else {
                            config._leftArrow.show();
                            config._rightArrow.show();
                        }

                        if (parseInt(config._slidesCount, 10) === 1) {
                            config._leftArrow.hide();
                            config._rightArrow.hide();
                        }

                        if (parseInt(config._slidesCount, 10) === 0) {
                            config._container.hide();
                            return;
                        }

                        if(!config.showArrows) {
                            config._leftArrow.hide();
                            config._rightArrow.hide();
                        }

                        // horizontal slider
                        if (config.layout === 'horizontal') {
                            var height;
                            if (!config.headline) {
                                height = config.height;
                            } else {
                                height = config.height - config._headline.outerHeight();
                            }
                            // vertical slider
                        } else {

                            if (config.outer) {
                                // Setting offset
                                config._slideOuterContainer.css({
                                    'top': config._leftArrow.outerHeight() + 'px',
                                    'height': config.height - config._headline.outerHeight() - (config._rightArrow.outerHeight() * 2) + 'px'
                                });
                            } else {
                                config._slideOuterContainer.css({
                                    'left': 0,
                                    'top': config._leftArrow.outerHeight() + 'px',
                                    'height': config.height - config._headline.outerHeight() + 'px'
                                });
                            }

                        }

                        // Adding numbers
                        if (config.showNumbers === true) {
                            if (config._numbers === null) {
                                config._numbers = $('<div>', {
                                    'class': 'slide_numbers'
                                }).insertAfter(config._headline);
                            }

                            var text = $.format(config.numberText, slideNumber, config._slidesCount);
                            config._numbers.empty().html(text);
                        }


                        config._activeSlide = slideNumber;

                        config._loader.fadeOut('fast');
                        config._slideContainer.fadeIn('slow');


                        return true;
                    }
                }
            });
        },

        /**
         * $.ajaxSlider.ajaxMode
         *
         * Requests the given url
         * and creates the needed container
         *
         * @param:  (obj) config - the plugin config
         */
        ajaxMode: function (config) {

            if (config.navigation === false) {
                $.ajaxSlider.createContainers(config);
                config._activeSlide = 1;
                $.ajaxSlider.getPage(config._activeSlide, config);

                config._rightArrow.bind('click', function (event) {
                    event.preventDefault();
                    $.ajaxSlider.getPage(config._activeSlide + 1, config);


                });
                config._leftArrow.bind('click', function (event) {
                    event.preventDefault();
                    $.ajaxSlider.getPage(config._activeSlide - 1, config);
                });

                if(!config.showArrows) {
                    config._leftArrow.hide();
                    config._rightArrow.hide();
                }


            } else {
                // Terminate request parameters
                var requestParams = {};
                if(config.extraParams) {
                    requestParams = config.extraParams;
                }
                // Load content with ajax
                if (config.url.length) {
                    $.ajax({
                        'url': config.url,
                        'data': requestParams,
                        'method': config.ajaxMethod,
                        'beforeSend': function () {

                            // Create AJAX Loader
                            config._loader = $('<div>', {
                                'text': config.loadingText,
                                'class': config.loadingContainer
                            }).appendTo(config._container);
                        },
                        'error': function () {
                            // Fadeout loader and hide container on error
                            config._loader.fadeOut('slow');
                            config._container.hide();
                        },
                        'success': function (result) {

                            // If the result is empty, hide container
                            if (!result.length) {
                                config._loader.fadeOut('slow');
                                config._container.hide();
                                return;
                            }

                            // Hide AJAX loader
                            window.setTimeout(function () {
                                config._loader.fadeOut('slow');
                                config._loader = null;


                                // Create the needed containers
                                $.ajaxSlider.createContainers(config);

                                //Fill the container and fade it in
                                config._slideContainer.html(result).fadeIn();

                                $.ajaxSlider.sliderNavigation(config);

                                // Configure the slider for both types
                                if (config.layout === 'horizontal') {
                                    $.ajaxSlider.horizontalSlider(config);
                                } else {
                                    $.ajaxSlider.verticalSlider(config);
                                }

                                // Create our own swipe gesturce
                                if($.ajaxSlider.isiPad) {
                                    $.ajaxSlider.initializeSwipeEvent(config);
                                }

                            }, 800);
                        }
                    });
                } else {
                    // Hide container if no url is passed
                    config._container.hide();
                }
            }
        },

        /**
         * $.ajaxSlider.localeMode
         *
         * Gets the given slides, creates the needed
         * container and places the slides in it
         *
         * @param:  (obj) config - the plugin config
         */
        localeMode: function (config) {

            // Getting inline slides
            var slides = $(config._this).find('.slide');

            // Create sliding outer container
            config._slideOuterContainer = $('<div>', {
                'class': 'sliding_outer'
            }).appendTo(config._container);

            // Create actual sliding container
            config._slideContainer = $('<div>', {
                'class': 'sliding_container',
                'html': slides
            }).prependTo(config._slideOuterContainer).hide().fadeIn();

            // Configure the slider for both types
            if (config.layout === 'horizontal') {
                $.ajaxSlider.horizontalSlider(config);
            } else {
                $.ajaxSlider.verticalSlider(config);
            }

            // Create our own swipe gesturce
            if($.ajaxSlider.isiPad) {
                $.ajaxSlider.initializeSwipeEvent(config);
            }

            // Create slider navigation
            if (config.showNumbers === true) {
                var timeout = window.setTimeout(function() {
                    $.ajaxSlider.sliderNavigation(config);

                    clearTimeout(timeout);
                    timeout = null;
                }, 80);
            }
        },

        /**
         * Custom swipe gesturcture implementation
         * which only handles horizontal swipes.
         *
         * The method contains an custom implementation
         * of the swipe gesture to provide the best possible
         * extensibility and control over the fired event(s)
         * and scrolling.
         *
         * @param {Object} plugin configuration
         * @returns {void}
         */
        initializeSwipeEvent: function(config) {
            var me = this, initialLeft = 0, containerLeft = 0,
                moveLeft = 0;

            // Bind the event listener for the custom event to handle
            // the slide change.
            config._this.bind('swipe.ajaxSlider', me.onHandleSwipeEvent);

            // Starting the gesture
            config._this.bind('touchstart', function(event) {
                containerLeft = config._slideContainer.css('left');
                containerLeft = ~~(1 * containerLeft.slice(0, -2));

                // Check if we're swiping right now
                if(!config.swipeRunning) {
                    //... if not, reset the control variables
                    if(moveLeft !== 0) {
                        moveLeft = 0;
                    }

                    if(initialLeft !== 0) {
                        initialLeft = 0;
                    }
                    initialLeft = event.originalEvent.touches[0].pageX;

                    config.swipeRunning = true;
                    config._slideContainer.css({
                        WebkitTransition: 'left 0s ease-out',
                        transition: 'left 0s ease-out'
                    });
                }
            });

            // Slide the sliding container
            config._this.bind('touchmove', function(event) {
                moveLeft = event.originalEvent.touches[0].pageX;
                var diffLeft = initialLeft - moveLeft;

                if(config.swipeRunning) {
                    if(diffLeft < -40 || diffLeft > 40) {
                        event.preventDefault();
                        config._slideContainer.css('left', -(config.scrollWidth * config._activeSlide + diffLeft));
                    }
                }
            });

            config._this.bind('touchend', function(event) {
                var diffLeft = initialLeft - moveLeft,
                    isRight = false, fireEvent;

                if(config.swipeRunning) {
                    config.swipeRunning = false;
                }

                if(diffLeft < 0) {
                    // Swipe to the right
                    diffLeft *= -1;
                    isRight = true;
                }

                if(diffLeft >= config.minSwipeDistance) {
                    fireEvent = (isRight) ? 'swipeRight' : 'swipeLeft';
                } else {
                    fireEvent = '';
                }

                if(fireEvent.length > 0) {
                    event.preventDefault();
                    config._this.trigger({ type: 'swipe.ajaxSlider', distance: diffLeft, direction: fireEvent, config: config, scope: me });
                } else {
                    config._slideContainer.css('left', -(config.scrollWidth * config._activeSlide));
                }

                config._this.unbind('ajaxSlider.click');
            });
        },

        /**
         * Event listener method which will be called when the user
         * swipes his finger at least the configured minimum swipe
         * distance ({@link config.minSwipeDistance}).
         *
         * The method changes the currently active slide and
         * cares that the slider changes to the correct slide (page).
         *
         * @event swipe.ajaxSlider
         * @param {Object} event - jQuery event object
         * @returns {Void}
         */
        onHandleSwipeEvent: function(event) {
            var me = event.scope, config = event.config;

            config._slideContainer.css({
                WebkitTransition: 'left 0.25s ease-out',
                transition: 'left 0.25s ease-out'
            });

            if(event.direction === 'swipeRight') {
                if((config._activeSlide - 1) >= 0) {
                    me.leftArrow(event, config);
                } else {
                    config._slideContainer.css('left', -(config.scrollWidth * config._activeSlide));
                }
            }

            if(event.direction === 'swipeLeft') {
                if((config._activeSlide + 1) < config._slidesCount) {
                    me.rightArrow(event, config);
                } else {
                    config._slideContainer.css('left', -(config.scrollWidth * config._activeSlide));
                }
            }

            if(config.layout === 'horizontal') {
                me.handleArrowsHorizontalSlider(config);
            } else if(config.layout === 'vertical') {
                me.handleArrowsVerticalSlider(config);
            }

            // Set navigation point to active
            if (config.navigation || config.showNumbers) {
                // Set this navigation point as active
                if(config._activeNavigation) {
                    config._activeNavigation.removeClass('active');
                }
                config._activeNavigation = config._this.find('#slideNavigation' + (config._activeSlide + 1)).addClass('active');
            }
        },

        /**
         * $.ajaxSlider.horizontalSlider
         *
         * Styles and creates all neeeded
         * components for a horizontal slider
         *
         * @param:  (obj) config - the plugin config
         */
        horizontalSlider: function (config) {
            var height, me = this, moveUp = 0, moveLeft = 0;
            if (!config.headline) {
                height = config.height;
            } else {
                height = config.height - config._headline.outerHeight();
            }

            if (config.navigation === true || config.navigation === false && config._mode === 'locale') {
                var slides = config._slideContainer.find('.slide');
                config._slideContainerWidth = 0;

                var timeout = window.setTimeout(function() {

                    $.each(slides, function (i, el) {
                        config._slideContainerWidth += $(el).outerWidth(true);
                    });
                    config._slideContainer.width(config._slideContainerWidth);

                    // Terminate slides count
                    config._slidesCount = slides.length;

                    // Show right arrow
                    if (config._slidesCount > 1) {
                        config._rightArrow.show();
                    }

                    if(!config.showArrows) {
                        config._leftArrow.hide();
                        config._rightArrow.hide();
                    }

                    // Right arrow
                    config._rightArrow.bind('click touchstart', function (event) {
                        $.ajaxSlider.rightArrow(event, config);
                    });

                    // Left arrow
                    config._leftArrow.bind('click touchstart', function (event) {
                        $.ajaxSlider.leftArrow(event, config);
                    });

                    config._this.find('a').bind('touchstart', function(event) {
                        var link = $(this), touchTimeout;
                        event.preventDefault();

                        if(!link.attr('href') && config.swipeRunning) {
                            return false;
                        }

                        touchTimeout = window.setTimeout(function(event) {
                            if(!link.attr('href')) {
                                return false;
                            }

                            if(!config.swipeRunning) {
                                window.location.href = link.attr('href');
                            }
                            window.clearTimeout(touchTimeout);
                            touchTimeout = null;
                        }, 200)

                    });

                    timeout = null;
                }, 80);

            }
        },

        /**
         * $.ajaxSlider.verticalSlider
         *
         * Styles and creates all neeeded
         * components for a vertical slider
         *
         * @param:  (obj) config - the plugin config
         */
        verticalSlider: function (config) {
            var me = this;

            // Setting the width of the slide container
            var slides = config._slideContainer.find('.slide');
            config._slideContainerWidth = 0;

            $.each(slides, function (i, el) {
                config._slideContainerWidth += $(el).width();
            });
            config._slideContainer.width(config._slideContainerWidth);

            // Position arrows
            config._leftArrow.css({
                'top': config._headline.outerHeight()
            });
            config._rightArrow.css({
                'top': config.height - config._rightArrow.outerHeight()
            });

            if (config.outer) {
                // Setting offset
                config._slideOuterContainer.css({
                    'top': config._leftArrow.outerHeight() + 'px',
                    'height': config.height - config._headline.outerHeight() - (config._rightArrow.outerHeight() * 2) + 'px'
                });
            } else {
                config._slideOuterContainer.css({
                    'left': 0,
                    'top': config._leftArrow.outerHeight() + 'px',
                    'height': config.height - config._headline.outerHeight() + 'px'
                });
            }

            if (config.navigation === true) {
                // Setting containerHeight
                var slides = config._slideContainer.find('.slide');
                config._slideContainerHeight = 0;

                $.each(slides, function (i, el) {
                    config._slideContainerHeight += $(el).height();
                });
                config._slideContainer.height(config._slideContainerWidth);

                // Getting the number of slides
                config._slidesCount = slides.length;

                // Show bottom arrow
                if (config._slidesCount > 1) {
                    config._rightArrow.show();
                }

                if(!config.showArrows) {
                    config._leftArrow.hide();
                    config._rightArrow.hide();
                }

                // Right arrow
                config._rightArrow.bind('click ', function (event) {
                    $.ajaxSlider.rightArrow(event, config);
                });

                // Left arrow
                config._leftArrow.bind('click touchstart', function (event) {
                    $.ajaxSlider.leftArrow(event, config);
                });

                config._this.find('a').bind('touchstart', function(event) {
                    var link = $(this), touchTimeout;
                    event.preventDefault();

                    if(!link.attr('href') && !config.swipeRunning) {
                        return false;
                    }

                    touchTimeout = window.setTimeout(function(event) {
                        if(!link.attr('href')) {
                            return false;
                        }

                        if(!config.swipeRunning) {
                            window.location.href = link.attr('href');
                        }
                        window.clearTimeout(touchTimeout);
                        touchTimeout = null;
                    }, 200)

                });
            }
        },

        rightArrow: function (event, config) {
            event.preventDefault();

            config._activeSlide++;
            clearInterval(config._rotateInterval);
            $.ajaxSlider.animateContainerTo(config._activeSlide, config);
        },

        leftArrow: function (event, config) {
            event.preventDefault();
            config._activeSlide--;
            window.clearInterval(config._rotateInterval);
            $.ajaxSlider.animateContainerTo(config._activeSlide, config);

        },

        /**
         * $.ajaxSlider.sliderNavigation
         *
         * Styles and creates all neeeded
         * components for a slider navigation
         *
         * @param:  (obj) config - the plugin config
         */
        sliderNavigation: function (config) {

            if(!config.showNumbers) {
                return false;
            }

            // Create an navigation controller and append it
            // to our main container
            config._slideNavigation = $('<div>', {
                'class': config.navigationClass
            }).prependTo(config._container);

            var i = 1;
            while (i <= config._slidesCount) {
                var a = $('<a>', {
                    'class': 'point',
                    'html': i,
                    'id': 'slideNavigation' + i,
                    'href': '#slide' + i
                }).appendTo(config._slideNavigation);
                i++;
            }

            // Set first link as active
            config._activeNavigation = config._slideNavigation.find('a:first').addClass('active');
            var links = config._slideNavigation.find('a');

            links.bind('click', function (event) {
                config._activeSlide = parseInt($(this).text(), 10) - 1;
                window.clearInterval(config._rotateInterval);
                $.ajaxSlider.animateContainerTo(config._activeSlide, config);
            });

        },

        /**
         * $.ajaxSlider.animateContainerTo
         *
         * This function handles the scrolling
         * of the sliding container
         *
         * @param:  (int) slideNumber - Number of the active slide
         * @param:  (obj) config - the plugin config
         */
        animateContainerTo: function (slideNumber, config) {
            var me = this;

            // Unbind the event listeners to prevent a unexcepted scrolling behaviors
            config._leftArrow.unbind('click');
            config._rightArrow.unbind('click');

            if (config.layout === 'horizontal') {

                if (config._slidesCount > 1) {

                    if(me.isiPad) {
                        config._slideContainer.css('left', -(config.scrollWidth * slideNumber));

                        var timeout = window.setTimeout(function() {

                            me.handleArrowsHorizontalSlider(config);

                            window.clearTimeout(timeout);
                            timeout = null;
                        }, config.scrollSpeed);
                    } else {
                        // Animate sliding container
                        config._slideContainer.animate({
                            'left': -(config.scrollWidth * slideNumber)
                        }, config.scrollSpeed, function () {

                            me.handleArrowsHorizontalSlider(config);
                        });
                    }
                }
            } else {
                if (config._slidesCount > 1) {

                    if(me.isiPad) {
                        config._slideContainer.css('top', -(config.scrollWidth * slideNumber));
                    }
                    config._slideContainer.animate({
                        'top': -(config.scrollWidth * slideNumber)
                    }, config.scrollSpeed, function () {

                        me.handleArrowsVerticalSlider(config);
                    });
                }
            }

            // Set navigation point to active
            if (config.navigation || config.showNumbers) {
                // Set this navigation point as active
                if(config._activeNavigation) {
                    config._activeNavigation.removeClass('active');
                }
                config._activeNavigation = config._this.find('#slideNavigation' + (slideNumber + 1)).addClass('active');
            }
        },

        handleArrowsVerticalSlider: function(config) {
            var me = this;
            if (config._slideContainer.position().top >= 0) {
                config._leftArrow.hide();
                config._rightArrow.show();
            } else if (config._slideContainer.position().top <= -(config.scrollWidth * (config._slidesCount - 1))) {
                config._leftArrow.show();
                config._rightArrow.hide();
            } else {
                config._leftArrow.show();
                config._rightArrow.show();
            }

            if(!config.showArrows) {
                config._leftArrow.hide();
                config._rightArrow.hide();
            }

            config._leftArrow.bind('click touchstart', function (event) {
                $.ajaxSlider.leftArrow(event, config);
            });
            config._rightArrow.bind('click touchstart', function (event) {
                $.ajaxSlider.rightArrow(event, config);
            });
        },

        handleArrowsHorizontalSlider: function(config) {
            var me = this;

            // Handling arrows
            if (config._slideContainer.position().left >= 0) {
                config._leftArrow.hide();
                config._rightArrow.show();
            } else if (config._slideContainer.position().left <= -(config.scrollWidth * (config._slidesCount - 1))) {
                config._leftArrow.show();
                config._rightArrow.hide();
            } else {
                config._leftArrow.show();
                config._rightArrow.show();
            }

            if(!config.showArrows) {
                config._leftArrow.hide();
                config._rightArrow.hide();
            }

            config._leftArrow.bind('click touchstart', function (event) {
                $.ajaxSlider.leftArrow(event, config);
            });
            config._rightArrow.bind('click touchstart', function (event) {
                $.ajaxSlider.rightArrow(event, config);
            });
        },

        /**
         * $.ajaxSlider.rotateSlider
         *
         * Rotates the slides automatically after
         * a given given period of time
         *
         * @param:  (obj) config - the plugin config
         */
        rotateSlider: function (config) {
            if (config._slidesCount > 1) {
                var i = 1;
                config._rotateInterval = window.setInterval(function () {
                    i++;
                    if (i > config._slidesCount) {
                        i = 1;
                    }
                    config._activeSlide = i - 1;
                    $.ajaxSlider.animateContainerTo(i - 1, config);
                }, config.rotateSpeed);
            }
        },
        debugMode: function (text, config) {
            if (config.debug === true) {
                console.log(text);
            }
        }
    };
})(jQuery);

/**
 * Loading Indicator Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */ (function ($) {

    $.loadingIndicator = {

        config: {
            'overlay': '#lbOverlay',
            'overlayOpacity': 0.6,
            'hideOverlayAfterClose': false,
            'loadingClass': 'loadingIndicator',
            'loadingText': 'Loading...',
            'animationSpeed': 500,
            'additionalCSS': {},
            'bindEvent': false,
            '_loader': null
        },

        open: function (settings) {

            // settings
            if (settings) {
                $.extend($.loadingIndicator.config, settings);
            }

            // Create loader
            $.loadingIndicator.config._loader = $('<div>', {
                'class': $.loadingIndicator.config.loadingClass,
                'text': $.loadingIndicator.config.loadingText
            }).hide().appendTo($(document.body));

            var height = $.loadingIndicator.config._loader.height(),
                    width = $.loadingIndicator.config._loader.width();

            $.loadingIndicator.config._loader.css({
                'marginTop': -(height / 2) + 'px',
                'marginLeft': -(width / 2) + 'px'
            });

            // Add additionalcss if passed
            if (!$.isEmptyObject($.loadingIndicator.config.additionalCSS)) {
                $.loadingIndicator.config._loader.css($.loadingIndicator.config.additionalCSS);
            }

            // Overlay handling
            if ($.loadingIndicator.config.hideOverlayAfterClose === true) {
                $($.loadingIndicator.config.overlay).fadeTo($.loadingIndicator.config.animationSpeed, $.loadingIndicator.config.overlayOpacity);
            }
            if ($.loadingIndicator.config.bindEvent === true) {
                $($.loadingIndicator.config.overlay).css({
                    'cursor': 'pointer'
                }).bind('click', function () {
                            $.loadingIndicator.close();
                        });
            } else {
                $($.loadingIndicator.config.overlay).css({
                    'cursor': 'default'
                });
            }
            if ($.browser.msie && parseInt($.browser.version, 10) === 6) {
                $.ie6fix.open($.loadingIndicator.config._loader);
            } else {
                $.loadingIndicator.config._loader.fadeIn($.loadingIndicator.config.animationSpeed);
            }

        },

        close: function () {
            if ($.loadingIndicator.config._loader) {
                $($.loadingIndicator.config.overlay).fadeOut($.loadingIndicator.config.animationSpeed);
                if ($.browser.msie && parseInt($.browser.version, 10) === 6) {
                    $.ie6fix.close($.loadingIndicator.config._loader);
                } else {
                    $.loadingIndicator.config._loader.animate({
                        'opacity': 0
                    }, $.loadingIndicator.config.animationSpeed, function () {
                        $.loadingIndicator.config._loader.remove();
                    });
                }
            }
        }
    };

})(jQuery);

/**
 * Simple Validation
 * for Shopware
 *
 * Shopware AG (c) 2010
 */ (function ($) {

    //Default settings
    var config = {
        errorClass: 'instyle_error',
        successClass: 'instyle_success'
    };

    $.fn.validate = function (settings) {

        if (settings) {
            $.extend(config, settings);
        }

        this.bind('blur', function (event) {
            validate($(this));
            return false;
        });

        return this;
    };

    validate = function (el) {
        var action;
        switch (el.attr('id')) {
            case 'register_personal_skipLogin':
            case 'register_personal_email':
            case 'register_personal_emailConfirmation':
                action = 'ajax_validate_email';
                break;
            case 'register_billing_ustid':
                action = 'ajax_validate_billing';
                break;
            case 'register_personal_password':
            case 'register_personal_passwordConfirmation':
                action = 'ajax_validate_password';
                break;
        }

        if (!el.val()) {
            setError(el);
            return;
        } else if (action) {
            ajaxValidate(el, action);
            return;
        } else {
            setSuccess(el);
            return;
        }
    };

    ajaxValidate = function (el, action) {
        var data = 'action=' + action + '&' + $('.register form').serialize();
        $.ajax({
            'data': data,
            'type': 'post',
            'dataType': 'json',
            'url': $.controller.ajax_validate,
            'success': function (result, data) {
                if (result && result.error_flags) {
                    for (var error_flag in result.error_flags) {
                        if (result.error_flags[error_flag]) {
                            setError($('.register .' + error_flag));
                        } else {
                            setSuccess($('.register .' + error_flag));
                        }
                    }
                }

                $('#' + action + '_error').remove();

                if (result && result.error_messages && result.error_messages.length) {
                    var error_css = {
                        'top': el.offset().top - 5,
                        'left': el.offset().left + el.outerWidth() + 15,
                        'position': 'absolute',
                        'z-index': 100
                    };

                    var error_el = $('<div>').attr('id', action + '_error').addClass('error').prependTo($('body')).css(error_css);

                    for (var error_key in result.error_messages) {
                        if(result.error_messages.length) {
                            var error_message = result.error_messages[error_key];
                            error_el.append(error_message + '<br />');
                        }
                    }
                }
            }
        });
    };

    //Sets error class
    setError = function (el) {
        if (!$.isEmptyObject(el)) {
            $.each($(el), function (i, e) {
                $(e).removeClass(config.successClass).addClass(config.errorClass);
            });
        } else {
            $(el).removeClass(config.successClass).addClass(config.errorClass);
        }
        return el;
    };

    //Sets success class
    setSuccess = function (el) {
        if (!$.isEmptyObject(el)) {
            $.each($(el), function (i, e) {
                $(e).removeClass(config.errorClass).addClass(config.successClass);
            });
        } else {
            $(el).removeClass(config.errorClass).addClass(config.successClass);
        }
        return el;
    };

})(jQuery);

/**
 * Liveshopping Plugin
 * for Shopware
 *
 * @deprecated
 *
 * Shopware AG (c) 2010
 */ (function ($) {

    $.fn.liveshopping = function () {

        // getting liveshopping info
        this.each(function () {

            // setting target time
            var target = new Date();
            target.setTime($(this).find('input.valid_to_ts').val() * 1000);

            // collection article details
            var article = {
                'article': $(this),
                'ordernumber': $(this).find('input.ordernumber').val(),
                'target': target,
                'uniquekey': $(this).find('input.uniquekey').val(),
                'max_quantity_enable': $(this).find('input.max_quantity_enable').val(),
                'max_quantity': $(this).find('input.max_quantity').val(),
                'sells': $(this).find('input.sells').val(),
                'typeID': parseInt($(this).find('input.typeID').val(), 10),
                'price': eval($(this).find('input.price').val()),
                'minPrice': eval($(this).find('input.minPrice').val())
                //'stints': $(this).find('input.stints').val().split(';')
            };

            // calling init function
            $.liveshopping.init(article, this);
        });

    };

    // extends jQuery's namespace
    $.liveshopping = {

        // initialize the liveshopping
        init: function (article, obj) {

            // article limitation
            var stints = $(obj).find('input.stints');
            if ($.isEmptyObject(stints) === true) {
                article.stints = $(stints).val().split(';');
            }

            // prepare ordernumber for sizzle
            article.ordernumber = article.ordernumber.replace(/\./g, '\\.');

            // refresh every second
            window.setInterval(function () {

                var now = $.server.dateObj;

                // check difference
                var diff = $.timestampDiff(article.target.getTime(), now.getTime());

                // liveshopping is running
                if (diff !== false) {

                    $.liveshopping.refreshDates(article, diff);

                    // if type standard
                    if (article.typeID === 1) {
                        $.liveshopping.refreshBarChart(article, diff);

                        if (article.max_quantity_enable) {
                            $.liveshopping.refreshQuantity(article);
                        }

                        // Minutes decrease
                    } else if (article.typeID === 2) {
                        $.liveshopping.refreshSecondsCounter(article, diff);
                        $.liveshopping.refreshPrices(article, diff);

                        // Minutes increase
                    } else {
                        $.liveshopping.refreshSecondsCounter(article, diff);
                        $.liveshopping.refreshPrices(article, diff);
                    }

                    // liveshopping is finished
                }
            }, 1000);
        },

        // changes bar chart labels which
        // are used by the standard type
        refreshDates: function (article, diff) {

            var key = article.uniquekey + article.ordernumber,
                    tmp;

            // days
            $('span.live' + key + '_days').each(function (index, item) {
                $(item).html(diff.d);
            });

            // days - double digit
            $('span.live' + key + '_days_doubledigit').each(function (index, item) {
                tmp = diff.d;
                tmp = tmp.toString();
                if (tmp.length === 1) {
                    $(item).html('0' + tmp);
                } else {
                    $(item).html(tmp);
                }
            });

            // hours
            $('span.live' + key + '_hours').each(function (index, item) {
                $(item).html(diff.h);
            });

            // hours - double digit
            $('span.live' + key + '_hours_doubledigit').each(function (index, item) {
                tmp = diff.h;
                tmp = tmp.toString();
                if (tmp.length === 1) {
                    $(item).html('0' + tmp);
                } else {
                    $(item).html(tmp);
                }
            });

            // minutes
            $('span.live' + key + '_min').each(function (index, item) {
                $(item).html(diff.m);
            });

            // minutes - double digit
            $('span.live' + key + '_min_doubledigit').each(function (index, item) {
                tmp = diff.m;
                tmp = tmp.toString();
                if (tmp.length === 1) {
                    $(item).html('0' + tmp);
                } else {
                    $(item).html(tmp);
                }
            });

            // seconds
            $('span.live' + key + '_sec').each(function (index, item) {
                $(item).html(diff.s);
            });

            // seconds - double digit
            $('span.live' + key + '_sec_doubledigit').each(function (index, item) {
                tmp = diff.s;
                tmp = tmp.toString();
                if (tmp.length === 1) {
                    $(item).html('0' + tmp);
                } else {
                    $(item).html(tmp);
                }
            });

        },

        // refreshs the bar chart which is used in the
        // standard liveshopping type
        refreshBarChart: function (article, diff, config) {

            var key = article.uniquekey + article.ordernumber;

            // days process bar
            $('div.live' + key + '_days_process').each(function (index, item) {
                var proz = eval(diff.d) * 100 / 31;
                if (proz > 100) {
                    proz = 100;
                }
                proz = 100 - proz;
                $(item).css('width', proz + '%');
            });

            // hours process bar
            $('div.live' + key + '_hours_process').each(function (index, item) {
                var proz = eval(diff.h) * 100 / 59;
                proz = 100 - proz;
                $(item).css('width', proz + '%');
            });

            // minutes bar chart
            $('div.live' + key + '_min_process').each(function (index, item) {
                var proz = eval(diff.m) * 100 / 59;
                proz = 100 - proz;
                $(item).css('width', proz + '%');
            });

            // seconds bar chart
            $('div.live' + key + '_sec_process').each(function (index, item) {
                var proz = eval(diff.s) * 100 / 59;
                proz = 100 - proz;
                $(item).css('width', proz + '%');
            });

        },

        // necessary for minutes increase and decrease
        refreshPrices: function (article, diff) {

            if (diff.s === 0) {

                var key = article.uniquekey + article.ordernumber;
                // calulating new price
                article.article.find('input.price').each(function (index, item) {
                    newPrice = eval($(item).val());
                });

                // setting new price
                $('strong.live' + key + '_display_price').each(function (index, item) {
                    newPrice2 = newPrice;
                    if (article.typeID === 3) {
                        newPrice2 = eval(newPrice2) + eval(article.minPrice);
                    } else {
                        newPrice2 = eval(newPrice2) - eval(article.minPrice);
                    }

                    $(item).text($.number_format(newPrice2, 2, ',', '.'));
                });

                // setting new price into hidden input
                article.article.find('input.price').val(newPrice2);
            }

        },

        // needed for max quantity
        refreshQuantity: function (article) {
            $('div.live' + article.uniquekey + article.ordernumber + '_instock_process').each(function (index, item) {
                var proc = eval(article.max_quantity) * 100;
                var total = eval(article.max_quantity) + eval(article.sells);
                proc = proc / total;
                proc = 100 - proc;
                $(item).css('width', proc + '%');
            });
        },

        // refresh seconds bar
        refreshSecondsCounter: function (article, diff) {
            $('div.live' + article.uniquekey + article.ordernumber + '_secbar_process').each(function (index, item) {
                var proc = eval(diff.s) * 100 / 59;
                $(item).css('width', proc + '%');
            });
        }

    };

})(jQuery);

/**
 * Livesearch Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
jQuery.fn.liveSearch = function (conf) {

    /**
     * Converts the url to a protocol relative url, so we don't need to manually
     * check the used http protocol. See the example from paul irish to get an idea
     * how it should work:
     *    `http://www.paulirish.com/2010/the-protocol-relative-url/`
     *    `http://blog.httpwatch.com/2010/02/10/using-protocol-relative-urls-to-switch-between-http-and-https/`
     *
     * @param {String} url - the url which needs to be converted
     * @returns {String} converted string
     */
    var convertUrlToRelativeUrl = function(url) {
        url = url.replace('https:', '');
        url = url.replace('http:', '');

        return url;
    };

    var config = jQuery.extend({
        url: '',
        id: 'search_results',
        duration: 400,
        typeDelay: 500,
        loadingClass: 'loading',
        onSlideUp: function () {},
        positionClass: 'active',
        position: -1,
        results: {},
        lastValue: '',
        timer: null,
        _left: null,
        _top: null
    }, conf);

    var liveSearch = jQuery('#' + config.id);

    if(config.hasOwnProperty('url') && config.url.length) {
        config.url = convertUrlToRelativeUrl(config.url);
    }

    // Create live-search if it doesn't exist
    if (!liveSearch.length) {
        liveSearch = jQuery('<div id="' + config.id + '"></div>').appendTo(document.body).hide().slideUp(0);

        // Close live-search when clicking outside it
        jQuery(document.body).bind('click.search', function (event) {
            var clicked = jQuery(event.target);

            if (!(clicked.is('#' + config.id) || clicked.parents('#' + config.id).length || clicked.is('input'))) {
                liveSearch.slideUp(config.duration, function () {
                    config.onSlideUp();
                });
            }
        });
    }

    return this.each(function () {
        var input = jQuery(this);
        var liveSearchPaddingBorderHoriz = parseInt(liveSearch.css('paddingLeft'), 10) + parseInt(liveSearch.css('paddingRight'), 10) + parseInt(liveSearch.css('borderLeftWidth'), 10) + parseInt(liveSearch.css('borderRightWidth'), 10);

        // Re calculates live search's position
        var repositionLiveSearch = function () {


            if (config._left === null || config._top === null) {
                liveSearch.show();
                if (config._left === null) {
                    config._left = parseInt(liveSearch.css('left'), 10);
                }
                if (config._top === null) {
                    config._top = parseInt(liveSearch.css('top'), 10);
                }
                liveSearch.hide();
            }

            var containerOffset = $('.container_20:first').offset();

            liveSearch.css({
                'left': containerOffset.left + config._left,
                'top': containerOffset.top + config._top
            });
        };

        // Shows live-search for this input
        var showLiveSearch = function () {
            // Always reposition the live-search every time it is shown
            // in case user has resized browser-window or zoomed in or whatever
            repositionLiveSearch();

            // We need to bind a resize-event every time live search is shown
            // so it resizes based on the correct input element
            $(window).unbind('resize', repositionLiveSearch);
            $(window).bind('resize', repositionLiveSearch);

            liveSearch.slideDown(config.duration);
        };

        // Hides live-search for this input
        var hideLiveSearch = function () {
            liveSearch.slideUp(config.duration, function () {
                config.onSlideUp();
            });
        };

        var doLiveSearch = function () {
            if (input.val() === config.lastValue) {
                return;
            }

            input.addClass(config.loadingClass);

            // Stop previous ajax-request
            if (config.timer) {
                clearTimeout(config.timer);
            }

            // Reset position
            config.position = -1;

            config.lastValue = input.val();

            // Start a new ajax-request in X ms
            config.timer = setTimeout(function () {
                jQuery.ajax({
                    'url': config.url,
                    'dataType': 'jsonp',
                    'cancelExisting': true,
                    'data': input.serialize(),
                    'beforeSend': function () {
                        $('div.inner_searchcontainer .ajax_loader').show();
                    },
                    'success': function (request) {
                        $('div.inner_searchcontainer .ajax_loader').hide();
                        input.removeClass(config.loadingClass);

                        // Show live-search if results and search-term aren't empty
                        if (request.length) {
                            liveSearch.html(request);
                            config.results = jQuery('#' + config.id + ' li');
                            showLiveSearch();
                        } else {
                            hideLiveSearch();
                        }
                    }
                });
            }, config.typeDelay);
        };

        input
            // On focus, if the live-search is empty, perform an new search
            // If not, just slide it down. Only do this if there's something in the input
                .focus(function () {
                    if (this.value !== '') {

                        // Perform a new search if there are no search results
                        if (liveSearch.html() === '') {
                            config.lastValue = '';
                            doLiveSearch();
                        }
                        // If there are search results show live search
                        else {
                            // HACK: In case search field changes width onfocus
                            setTimeout(showLiveSearch, 1);
                        }
                    }
                })
            // Auto update live-search onkeyup
                .keydown(function (event) {


                    doLiveSearch();

                    if (config.results && config.results.length && (event.keyCode === 38 || event.keyCode === 40)) {
                        $(config.results[config.position]).removeClass(config.positionClass);
                        if (event.keyCode === 40) {
                            config.position++;
                            if (config.position === config.results.length) {
                                config.position = -1;
                            }
                        } else if (event.keyCode === 38) {
                            if (config.position === -1) {
                                config.position = config.results.length;
                            }
                            config.position--;
                        }
                        if (config.position !== -1) {
                            $(config.results[config.position]).addClass(config.positionClass);
                        }
                    }

                    if (event.keyCode === 13 && config.position !== -1) {

                        var target = $(config.results[config.position]).find('a').attr('href');
                        location.href = target;
                        return false;
                    }
                });
    });
};

/**
 * Utitilies Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */

(function ($) {

    // Methods to fix the select box bug
    // and the missing position fixed
    $.ie6fix = {
        _init: function () {
            if ($.browser.msie && parseInt($.browser.version, 10) === 6) {
                $.ie6fix.open(modal, config);
            } else {
                return false;
            }
        },
        open: function (obj) {
            // Hide select boxes
            $('select:visible').css('visibility', 'hidden');

            // Fix missing 'position: fixed'
            obj.css({
                'position': 'absolute',
                'top': document.body.scrollTop + 100 + 'px'
            }).fadeIn();

            $(window).bind('scroll', function (event) {
                obj.css('top', document.body.scrollTop + 100 + 'px');
            });
        },
        close: function (obj) {
            // Show select boxes
            $('select:hidden').css('visibility', 'visible');

            obj.fadeOut();

            // Fix missing 'position: fixed'
            $(window).unbind('scroll');
        },
        selectHide: function (selector) {
            if (selector) {
                $(selector + ' select, #detail .liveshopping_detail, .accessory_container').css('visibility', 'hidden');
            } else {
                $('select').css('visibility', 'hidden');
            }
        },
        selectShow: function () {
            $('select, #detail .liveshopping_detail, .accessory_container').css('visibility', 'visible');
        },
        selectOnlyShow: function () {
            $('select').css('visibility', 'visible');
        }
    };

    // Formats a string
    // Syntax: $.format('<div class="%0"'>%1</div>, [value for %0], [value for %1], ...)
    $.format = function (str) {
        for (var i = 1; i < arguments.length; i++) {
            str = str.replace('%' + (i - 1), arguments[i]);
        }
        return str;
    };

    //Extends jQuery's namespace
    $.server = {
        dateObj: {}
    };

    //Initialized the server time which
    //is used by the liveshopping module
    $.server.init = function (servertime) {
        $.server.dateObj = new Date();
        $.server.dateObj.setTime(servertime * 1000);
        window.setInterval(function () {
            $.server.increment();
        }, 1000);
    };
    $.server.increment = function () {
        var crntTime = $.server.dateObj.getTime() + 1000;
        $.server.dateObj = new Date(crntTime);
    };

    //Formats floats
    $.number_format = function (number, decimals, dec_point, thousands_sep) {
        var n = number,
                prec = decimals;
        var toFixedFix = function (n, prec) {
            var k = Math.pow(10, prec);
            return (Math.round(n * k) / k).toString();
        };
        n = !isFinite(+n) ? 0 : +n;
        prec = !isFinite(+prec) ? 0 : Math.abs(prec);
        var sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep;
        var dec = (typeof dec_point === 'undefined') ? '.' : dec_point;
        var s = (prec > 0) ? toFixedFix(n, prec) : toFixedFix(Math.round(n), prec);
        var abs = toFixedFix(Math.abs(n), prec);
        var _, i;
        if (abs >= 1000) {
            _ = abs.split(/\D/);
            i = _[0].length % 3 || 3;
            _[0] = s.slice(0, i + (n < 0)) + _[0].slice(i).replace(/(\d{3})/g, sep + '$1');
            s = _.join(dec);
        } else {
            s = s.replace('.', dec);
        }
        var decPos = s.indexOf(dec);
        if (prec >= 1 && decPos !== -1 && (s.length - decPos - 1) < prec) {
            s += new Array(prec - (s.length - decPos - 1)).join(0) + '0';
        } else if (prec >= 1 && decPos === -1) {
            s += dec + new Array(prec).join(0) + '0';
        }
        return s;
    };

    //Changes the state of the related articles which is
    //used by the bundle module
    $.changeRelatedArticleState = function (ordernumber, active) {
        var tmpContainerName = '#' + ordernumber + '_related_container';
        if (false === active) {
            $(tmpContainerName).hide();
        } else {
            $(tmpContainerName).show();
        }
    };

    //Gets the difference between two timestamps
    //which is used by the live shopping module
    $.timestampDiff = function (d1, d2) {
        if (d1 < d2) {
            return false;
        }
        var d = Math.floor((d1 - d2) / (24 * 60 * 60 * 1000));
        var h = Math.floor(((d1 - d2) - (d * 24 * 60 * 60 * 1000)) / (60 * 60 * 1000));
        var m = Math.floor(((d1 - d2) - (d * 24 * 60 * 60 * 1000) - (h * 60 * 60 * 1000)) / (60 * 1000));
        var s = Math.floor(((d1 - d2) - (d * 24 * 60 * 60 * 1000) - (h * 60 * 60 * 1000) - (m * 60 * 1000)) / 1000);
        return {
            'd': d,
            'h': h,
            'm': m,
            's': s
        };
    };

    //Changes the displayed informations on the
    //article detail site and changes the active
    //images which is used by variant articles
    $.changeDetails = function (ordernumber) {
        if (ordernumber) {
            ordernumber = ordernumber.replace(/\./g, '\\.');
        }
        if (typeof ($.checkNotification) === 'function') {
            if (!ordernumber) {
                $.checkNotification($.ordernumber);
            } else {
                $.checkNotification(ordernumber);
            }
        }
        try {
            if (!ordernumber || $('#instock_' + ordernumber).val() > 0) {
                $('#article_notification').hide();
                $('#detailCartButton').show();
                $('#detailBuyInfoNotAvailable').hide();
            } else {
                $('#article_notification').show();
                var hideBasket = $('#notifyHideBasket').val();
                hideBasket = ~~hideBasket;

                if (hideBasket) {
                    $('#detailCartButton').hide();
                }
                if ($('#detailBuyInfoNotAvailable').length) {
                    $('#detailCartButton').hide();
                    $('#detailBuyInfoNotAvailable').show();
                }
            }
        } catch (e) {}

        if (!ordernumber) {
            // Hide Pseudoprice
            $('.PseudoPrice').hide();

            // Hide all other thumbnails
            if (isVariant) {
                var thumbs = $('.thumb_box').children('a:[id]');
                thumbs.each(function (i, el) {
                    if ($(el).attr('id') !== 'thumb' + $.ordernumber) {
                        $(el).hide();
                    }
                });
            }
            // Hide delivery info
            $('.delivery_container').hide();
            // Hide basket
            $('#basketButton').css('opacity', '0.4');
        } else {

            // Show Pseudo price
            $('#' + ordernumber).find('.PseudoPrice').show();

            // Show delivery info
            $('.delivery_container').show();

            // Change informations
            $('#article_details').html($('#' + ordernumber).html());

            //Set basket button to active
            $('#basketButton').css('opacity', '1.0');

            // Change main image
            $('a#zoom1 img').attr('src', $('#img' + ordernumber).find('img').attr('src'));

            if (ordernumber !== $.ordernumber) {

                // ZoomViewer active...
                var useZoom = parseInt(useZoom, 10);
                if (useZoom) {
                    var img_link = $('a#zoom1 img');

                    // Refresh src attribute
                    if (img_link.attr('src')) {
                        $('a#zoom1 img').attr('src', $('#img' + ordernumber).find('img').attr('src'));
                    }
                    // Refresh img title
                    if (img_link.attr('title')) {
                        img_link.attr('title', $('#img' + ordernumber).children('a').attr('title'));
                    }

                    // If image found and the neccessary attributes are set
                    // fire the click event to change the image over the
                    // CloudZoom plugin
                    if (img_link.attr('src') && img_link.attr('title')) {
                        $('#img' + ordernumber).find('a').trigger('click');
                    }
                } else {
                    // Change lightbox link
                    $('a#zoom1').attr('href', $('#img' + ordernumber).children('a').attr('href'));
                }

                // Change active thumbnail image
                $('#thumb' + $.ordernumber).hide();
                $('#thumb' + ordernumber).show();


                // Set the new ordernumber in the global scope
                $.ordernumber = ordernumber;
                try {
                    $('#variantOrdernumber').val(ordernumber);
                } catch (err) {

                }
            }
        }
        // Try to active liveshopping
        try {
            $('#article_details').liveshopping();
        } catch (err) {}
    };

    //Check if the article are set up for
    //email notification and checks if
    //a notification was sent
    $.checkNotification = function (ordernumber) {
        if (typeof (variantOrdernumberArray) === 'undefined') {
            return;
        }
        var isSet = false;
        try {
            for (var i = 0; i < variantOrdernumberArray.length; ++i) {
                if (variantOrdernumberArray[i] === ordernumber) {
                    isSet = true;
                    try {
                        $('#articleNotificationWasSend').show();
                    } catch (e) {}
                    try {
                        $('#sendArticleNotification').hide();
                    } catch (e) {}
                }
            }
        } catch (err) {}
    };

})(jQuery);

/**
 * Bundle Plugin
 * for Shopware
 *
 * @deprecated
 *
 * Shopware AG (c) 2010
 */ (function ($) {

    var config = {
        'ordernumber': $.ordernumber
    };

    $.bundle = {

        changeDetails: function (selector, ordernumber) {

            // setting config ordernumber
            if (typeof (ordernumber) !== 'undefined') {
                config.ordernumber = ordernumber;
            } else {
                config.ordernumber = $.ordernumber;
            }

            var bundles = $(selector).find('.bundle_bundles_details').text();
            var related = $(selector).find('.bundle_related_articles').text();
            var article = $(selector).find('.bundle_article_details').text();

            // evil !!!
            if (bundles.length) {
                eval("bundles = (" + bundles + ")");
            }
            if (related.length) {
                eval("related = (" + related + ")");
            }
            if (article.length) {
                eval("article = (" + article + ")");
            }

            // Related articles
            if (typeof (related) === 'object' && parseInt(article.crossbundlelook, 10) === 1) {
                $.bundle.processRelatedArticles(related, article);
            }

            // Bundles
            if (typeof (bundles) === 'object') {
                $.bundle.processBundle(bundles, article, selector);
            }
        },

        calculatePrice: function (bundle, ordernumber) {

            var articlePriceSelector = 'input#price_' + ordernumber;

            // Calculate total price
            var price_rab_span = $('#price_rabAbs_' + bundle.id);
            var articlePrice = $(articlePriceSelector).val();
            var bundleArticlesTotalPrice = bundle.sBundleArticlesTotalPrice.display;

            if (price_rab_span !== null && articlePrice !== null && bundleArticlesTotalPrice !== null) {
                var rabTotal = eval(articlePrice) + eval(bundleArticlesTotalPrice);
                price_rab_span.text($.number_format(rabTotal, 2, ',', '.'));
            }

            // Calculate bundle price
            var price_bundle_span = $('#price_bundle_' + bundle.id);
            if (price_bundle_span !== null) {

                // Calculate total discount
                if (bundle.rab_type === "abs") {
                    var bundle_price = bundle.sBundlePrices.display;
                    price_bundle_span.text($.number_format(bundle_price, 2, ',', '.'));
                } else {
                    // Calculate percental discount
                    var percentage = bundle.sBundlePrices.percentage;
                    var tmpDiscount = (eval(rabTotal) / 100) * (eval(percentage));
                    var bundle_price = eval(rabTotal) - eval(tmpDiscount);
                    price_bundle_span.text($.number_format(bundle_price, 2, ',', '.'));
                }
            }

            // Discount in percentage
            var price_rabPro_span = $('#price_rabPro_' + bundle.id);
            var rabPro = 100 - (eval(bundle_price) * 100 / eval(rabTotal));

            if (price_rabPro_span !== null && rabPro !== null) {
                price_rabPro_span.text($.number_format(rabPro, 2));
            }
        },

        processBundle: function (bundles, article, selector) {

            // Bundle display flag
            // Will be true if at least
            // one bundle article is active
            var showBundleBox = false;

            $.each(bundles, function (i, bundle) {

                // Mark variant ordernumber as selected article
                $('input[name=sAddBundle]').each(function (i, item) {
                    $(item).val(config.ordernumber);
                });

                $.bundle.calculatePrice(bundle, config.ordernumber.replace('\.', '\\.'));


                // Instock check for variant articles
                if (!$.isEmptyObject(bundle.sBundleStints)) {

                    $('.bundle').hide();

                    $('#sAdd.variant').change(function () {
                        var ordernumber = $(this).val();
                        var instock = $('#instock_' + ordernumber.replace('\.', '\\.')).val();

                        // refresh price
                        $.bundle.calculatePrice(bundle, ordernumber);

                        if (instock.length) {

                            if (instock >= 0) {
                                if (showBundleBox) {
                                    $(selector).show();
                                }
                            } else {
                                $('.bundle').hide();
                            }
                        } else {

                            // Show bundle box, if at least one
                            // one bundle artice is active
                            if (showBundleBox) {
                                $('.bundle').show();
                            }
                        }

                    });
                }

                // Check if we've article limitations
                if ($.isArray(bundle.sBundleStints)) {

                    // Hide bundle box and check for
                    // entitled articles
                    $('#bundle_set_' + bundle.id).hide();

                    // Pass-through ordernumber, which will
                    // be displayed
                    $.each(bundle.sBundleStints, function (j, stints) {
                        var ordernumberToUpper = config.ordernumber.toUpperCase();

                        if (ordernumberToUpper === stints) {
                            showBundleBox = true;

                            // show bundle box
                            $('#bundleset_' + bundle.id).show();
                        }
                    });
                } else {
                    $('.bundle').fadeIn();
                }
            });

            // Show bundle box, if at least one
            // one bundle artice is active
            if (showBundleBox) {
                $('.bundle').show();
            }

            /*if(!$.isEmptyObject(article.sVariants)) {
             $('.bundle').hide();
             } */
        },

        processRelatedArticles: function (related, article) {

            // Release related article box
            try {
                $('.relatedbox_container').show();
            } catch (err) {}

            // Caching ordernumber and price
            $('#related_main_ordernumber').val(config.ordernumber);
            $('#selected_articel_price').val($('#price_' + config.ordernumber).val());
            $.refreshRelatedArticle();

            // Deposit images
            try {
                var tmpBundleImg = $('#related_main_image');
                var tmpSourceImg = $('#img_1_' + config.ordernumber);

                if (tmpSourceImg !== null) {
                    tmpBundleImg.html(tmpSourceImg.html());
                }
            } catch (err) {}
        }

    };


    // Main bundle function
    // exam.: $('.bundlebox').bundle();
    $.fn.bundle = function (settings) {

        if (settings) {
            $.extend(config, settings);
        }

        this.each(function () {
            $.bundle.changeDetails(this);
        });
    };

    //Refreshes the relatedArticles which is
    //used by the bundle module
    $.refreshRelatedArticle = function () {
        var relatedOrdernumbers = '';
        var totalPrice = $('#selected_articel_price').val();

        $('input[class=relatedOrdernumber]').each(function (i, item) {
            var tmpOrdernumber = $(item).val();

            /**
             * Fix issue with sizzle selector engine and ordernumbers
             * which includes dots
             */
            tmpOrdernumber = tmpOrdernumber.replace(/(:|\.)/g, '\\$1');

            var tmpContainerName = '#related_' + tmpOrdernumber + '_image';
            var tmpPlusiconName = '#related_' + tmpOrdernumber + '_plus';
            var tmpPriceName = '#' + tmpOrdernumber + '_price';
            var checkbox = $('#' + tmpOrdernumber + '_related_checkbox');
            if (checkbox.is(':checked')) {
                $(tmpContainerName).fadeIn('fast');
                $(tmpPlusiconName).fadeIn('fast');
                if ('' === relatedOrdernumbers) {
                    relatedOrdernumbers = tmpOrdernumber;
                }
                else {
                    relatedOrdernumbers += ';' + tmpOrdernumber;
                }
                var tmpPrice = $(tmpPriceName).val();
                if (tmpPrice) {
                    totalPrice = eval(totalPrice) + eval(tmpPrice);
                }
            } else {
                $(tmpContainerName).fadeOut('fast');
                $(tmpPlusiconName).fadeOut('fast');
            }
        });
        $('#sRelatedOrdernumbers').val(relatedOrdernumbers);
        $('#price_relatedbundle').html($.number_format(totalPrice, 2, ',', '.'));
    };

})(jQuery);

/**
 * Compare Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */ (function ($) {

    //Extends jQuery's namespace
    $.compare = {};

    //Default options
    $.compare.options = {
        viewportAjax: '',
        compareContainer: '#compare_bigbox',
        compareOverlay: '#lbOverlay',
        resultsContainer: '#compareContainerResults',
        ajaxContainer: '#compareContainerAjax',
        compareHighlight: '#compareHighlight',
        highlightSpeed: 1750,
        highlightColor: '#dd4800',
        dataType: 'jsonp',
        requestType: 'post',
        animationSpeed: 400,
        topLink: '#top',
        maxCount: 5,
        compareCount: 0
    };

    //Sets user settings
    $.compare.setup = function (params) {
        if (params) {
            $.each(params, function (i, param) {
                $.compare.options[i] = param;
            });
        }

        if (compareMaxCount) {
            $.compare.options.maxCount = parseInt(compareMaxCount, 10);
        }
        if (compareCount) {
            $.compare.options.compareCount = parseInt(compareCount, 10);
        }

        //binding events
        $('.compare_delete_all').live('click', function (event) {
            $.compare.deleteComparisons(this.href);
            event.preventDefault();
        });
        $('.compare_add_article').live('click', function (event) {
            $.compare.addCompare(this.href);
            event.preventDefault();
        });
        $('.compare_get_overlay').live('click', function (event) {
            $.compare.startComparison(this.href);
            event.preventDefault();
        });
        $('.compare_delete_article').live('click', function (event) {
            $.compare.deleteCompare(this.href);
            event.preventDefault();
        });
    };

    //Displays the compare container
    $.compare.showCompare = function () {
        $($.compare.options.compareHighlight).addClass('active');
        $($.compare.options.resultsContainer).show();
    };

    //Hides the compare container
    $.compare.hideCompare = function () {
        $($.compare.options.compareHighlight).removeClass('active');
        $($.compare.options.resultsContainer).hide();
    };

    //Hides the compare window
    $.compare.hideCompareList = function () {
        $($.compare.options.compareContainer).animate({
            'top': -($($.compare.options.compareContainer).height() + 100) + 'px'
        });
        $($.compare.options.compareOverlay).fadeOut();
    };

    //Requests the compare informations
    $.compare.startComparison = function (url) {
        $.ajax({
            'dataType': $.compare.options.dataType,
            'type': $.compare.options.requestType,
            'url': url,
            'success': function (result) {
                var count = result.match(/compare_article/gi).length;

                var container = $('<div>', {
                    'class': 'ajax_compare_container'
                }).appendTo(document.body);
                var div = $('<div>', {
                    'class': 'grid_3'
                }).appendTo(container);

                container.show();
                var tmpWidth = parseInt(div.css('width'), 10);
                container.remove();

                var width = (tmpWidth * count) + tmpWidth;
                if ($.browser.msie && parseInt($.browser.version, 10) === 6) {
                    width += 2;
                }

                $.modal(result, '', {
                    'width': width + 'px',
                    'top': '30px',
                    'textContainer': '<div>',
                    'textClass': 'ajax_compare_container'
                });
            }
        });
    };

    //Adds an article with it's article id
    //to the current compare list
    $.compare.addCompare = function (url) {
        $.ajax({
            'dataType': $.compare.options.dataType,
            'type': $.compare.options.requestType,
            'url': url,
            'success': function (result) {
                if (result.indexOf('class="modal_close"') !== -1) {
                    var width = 500;
                    var position = 'fixed';

                    if ($.browser.msie && parseInt($.browser.version, 10) === 6) {
                        width += 2;
                        position = 'absolute';
                    }
                    $.modal(result, '', {
                        'position': position,
                        'width': width + 'px',
                        'textContainer': '<div>',
                        'textClass': 'ajax_compare_max_container'
                    });
                    return;
                }
                $($.compare.options.ajaxContainer).html(result);
                window.location = $.compare.options.topLink;
            }
        });
    };

    //Deletes an article with it's article id
    //from the current compare list
    $.compare.deleteCompare = function (url) {
        $.ajax({
            'dataType': $.compare.options.dataType,
            'type': $.compare.options.requestType,
            'url': url,
            'beforeSend': function () {
                //$.compare.options.compareCount = $.compare.options.compareCount - 1;
                //compareCount = $.compare.options.compareCount - 1;
            },
            'success': function (result) {
                $($.compare.options.ajaxContainer).html(result);
            }
        });
    };

    //Deletes the current compare list
    $.compare.deleteComparisons = function (url) {
        $.ajax({
            'dataType': $.compare.options.dataType,
            'type': $.compare.options.requestType,
            'url': url,
            'crossDomain': true,
            'beforeSend': function () {
                $.compare.options.compareCount = 0;
                compareCount = $.compare.options.compareCount;
            },
            'success': function () {
                $($.compare.options.ajaxContainer).empty();
            }
        });
    };
})(jQuery);

/**
 * Modal Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */
(function ($) {

    $(document).ready(function() {
        $('.modal_open a').unbind('click');
        $('.modal_open a').modal();
        $('.basket_details .title.detail-modal, form a.thumb_image.detail-modal').bind('click', function(event) {
            event.preventDefault();

            var $this = $(this),
                title = $this.parents('form').find('a.title').html(),
                url = $this.attr('href');

            if(title.length > 65) {
                title = title.substring(0, 65) + '...';
            }

            $.modalFrame(url + (url.indexOf('?') === -1 ? '?' : '&') + 'template=ajax', title, {
                width: 600,
                frameHeight: 500,
                useOverlay: true,
                position: 'fixed',
                headlineCls: 'headingbox'
            });
        });
    });

    //Default settings
    var config = {
        animationSpeed: 500,
        frameHeight: '500px',
        textClass: '',
        textContainer: '<p>',
        overlay: '#lbOverlay',
        overlayOpacity: '0.6',
        useOverlay: true,
        width: 500,
        height: 500
    };

    $.fn.modal = function () {
        return this.each(function () {
            var $this = $(this);

            $this.bind('click', function (event) {
                event.preventDefault();
                var me = $(this),
                        width = me.attr('data-modal-width'),
                        height = me.attr('data-modal-height');

                width = width || config.width;
                height = height || config.height;

                $.ajax({
                    type: 'post',
                    url: me.attr('href'),
                    data: {
                        isXHR: 1
                    },
                    success: function (data) {
                        var modal = $.modal(data, '', {
                            'position':'fixed',
                            'width': parseInt(width, 10),
                            'height': parseInt(height, 10)
                        });

                        // Remove close icon
                        modal.find('.close').remove();
                    }
                });
            });
        });
    };

    //creates an modal window with text and headline
    $.modal = function (text, headline, settings) {
        settings = settings || {};
        settings = $.extend({}, config, settings);

        if ($('.modal')) $('.modal').remove();
        var modal = $('<div>', {
            'class': 'modal',
            'css': {
                'width': settings.width
            }
        });

        if (headline.length) {
            var h2 = $('<h2>', {
                'html': headline
            }).appendTo(modal);
        }
        if (text.length) {
            var container = $(settings.textContainer, {
                'html': text
            });

            if (settings.textClass.length) {
                container.addClass(settings.textClass)
            }
            container.appendTo(modal);
        }

        //get css properties
        modal.show();
        if(!settings.position) {
            settings.position = modal.css('position');
        }
        settings.top = modal.css('top');
        modal.hide();

        modal.appendTo('body');

        if(settings.height) {
            modal.find('.inner_container').css('height', settings.height + 'px');
        }

        modal.show().css('marginLeft', -(modal.width()/2)).hide();

        if (settings.useOverlay == true) {
            $.modal.overlay.fadeIn();

            $(settings.overlay).bind('click', function (event) {
                $.modalClose();
            });
        }
        $('.modal').fadeIn('fast');

        if($.browser.msie && parseInt($.browser.version) == 6) {
            $.ie6fix.open(modal, config);
        } else {
            if (settings.position == 'absolute') {
                modal.css({
                    'position': settings.position,
                    'bottom': 'auto'
                }).fadeIn(settings.animationSpeed);
            } else if (settings.position == 'fixed') {
                $('.modal').fadeIn();
                modal.css({
                    'position': settings.position,
                    'top': -(modal.height() + 100) + 'px',
                    'display': 'block'
                }).animate({
                            'top': '40px'
                        }, settings.animationSpeed)
            }
        }

        return modal
    };

    //Cloeses the current modal window
    $.modalClose = function () {
        if (config.useOverlay == true) {
            $.modal.overlay.fadeOut()
        }

        if($.browser.msie && parseInt($.browser.version) == 6) {
            $.ie6fix.close($('.modal'), config);
        } else {
            if (config.position == 'absolute') {
                $('.modal').fadeOut(config.animationSpeed)
            } else if (config.position == 'fixed') {
                $('.modal').animate({
                    'top': -($('.modal').height() + 100) + 'px'
                }, config.animationSpeed)
            }
            $('.modal').fadeOut();
        }
    };

    //Creates a modal window with an iframe and a headline
    $.modalFrame = function (url, headline, settings) {
        if (settings) $.extend(config, settings);
        config.animationSpeed = parseInt(config.animationSpeed);
        if ($('.modal')) $('.modal').remove();
        var modal = $('<div>', {
            'class': 'modal',
            'css': {
                'width': config.width,
                'left': '50%',
                'border': config.border,
                'padding': config.padding,
                'background': config.background,
                'display': 'none',
                'margin-left': -(parseInt(config.width) / 2)
            }
        });

        if (headline && headline.length) {
            var h2 = $('<h2>', {
                'text': headline
            }).appendTo(modal)

            if(settings.headlineCls) {
                h2.addClass(settings.headlineCls);
            }
        }
        if (url.length) {
            var div = $('<iframe>', {
                'src': url,
                'css': {
                    'height': config.frameHeight
                }
            }).appendTo(modal)
        }
        var close = $('<a>', {
            'html': 'Schlie&szlig;en',
            'class': 'close'
        }).appendTo(modal);
        close.bind('click', function (event) {
            event.preventDefault();
            if (config.position == 'absolute') {
                modal.fadeOut(config.animationSpeed)
            } else if (config.position == 'fixed') {
                modal.animate({
                    'top': -(modal.height() + 100) + 'px'
                }, config.animationSpeed)
            }
            if(config.useOverlay) {
                $.modal.overlay.fadeOut();
            }
        });

        if (config.useOverlay == true) {
            $.modal.overlay.fadeIn();

            $(config.overlay).bind('click', function (event) {
                $.modalClose();
            });
        }

        modal.appendTo('body');
        modal.fadeIn('fast');

        if($.browser.msie && parseInt($.browser.version) == 6) {
            $.ie6fix.open(modal, config);
        } else {
            if (config.position == 'absolute') {
                modal.css({
                    'position': config.position,
                    'bottom': 'auto'
                }).fadeIn(config.animationSpeed);
            } else if (config.position == 'fixed') {
                $('.modal').fadeIn();
                modal.css({
                    'position': config.position,
                    'top': -(modal.height() + 100) + 'px',
                    'display': 'block'
                }).animate({
                            'top': '40px'
                        }, config.animationSpeed)
            }
        }

        return modal;
    };

    //Handles the modal overlay
    $.modal.overlay = {
        fadeIn: function () {
            $(config.overlay).css({
                'display': 'block',
                'opacity': '0'
            }).animate({
                        'opacity': '0.4'
                    }, 500)
        },
        fadeOut: function () {
            $(config.overlay).animate({
                'opacity': '0'
            }, 500).hide()
        }
    };
})(jQuery);


/**
 * AJAX Login Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */ (function ($) {

    //Default settings
    var config = {
        dataType: 'text',
        container: '.modal',
        headline: '',
        viewport: '',
        register: '',
        checkout: '',
        target: '',
        type: 'POST'
    };

    //Extends jQuery's function namespace
    $.fn.checkout = function (settings) {
        if (settings) {
            $.extend(config, settings);
        }

        $(config.container + ' form').live('submit', function (event) {
            if (!$(this).hasClass('new_customer_form')) {
                //event.preventDefault();
                return $.checkout.loginUser(this);
            }
        });
        $(config.container + ' .existing_customer input[type^=submit]').live('click', function (event) {
            //event.preventDefault();
            var form = $(config.container + ' form[name^=existing_customer]');
            return $.checkout.loginUser(form);
        });

        this.live('click', function (event) {
            event.preventDefault();
            $.checkout.checkUser(this.href);
        });

        return this;
    };


    //Extends jQuery's namespace
    $.checkout = {};

    //Checks the user
    $.checkout.checkUser = function (target, event) {
        config.target = target;
        $.ajax({
            'url': config.viewport,
            'dataType': 'jsonp',
            'type': config.type,
            'success': function (result) {
                if (result.length) {
                    var width = 530;
                    var position = 'fixed';

                    if ($.browser.msie && parseInt($.browser.version, 10) === 6) {
                        width = 530;
                        position = 'absolute';
                    }

                    $.modal(result, config.headline, {
                        'position': position,
                        'textClass': '',
                        'textContainer': '<div>',
                        'width': width + 'px'
                    }).find('.close').remove();

                    if ($.browser.msie) {
                        buttons = $('.modal').find('input[type^=submit]');
                        buttons.each(function () {
                            this.fireEvent('onmove');
                        });
                    }

                    // user is logged in
                } else {
                    window.location.href = target;
                }
            }
        });
    };

    //Checks if the user is logged in
    $.checkout.loginUser = function (form) {
        config.register = $.controller.register;
        var location = window.location.protocol + '//' + window.location.host;

        // Fix same origin miss match
        if (config.viewport.indexOf(location) !== 0 && $.browser.msie) {
            return;
        }
        $.ajax({
            url: config.viewport,
            data: $(form).serialize(),
            type: config.type,
            xhrFields: {
                withCredentials: true
            },
            success: function (result) {
                if (result.length) {
                    $(config.container).empty().html(result);
                } else {
                    window.location.href = config.target ? config.target : config.checkout;
                }
            },
            error: function (result) {
                window.location.href = config.target ? config.target : config.checkout;
            }
        });
        return false;
    };
})(jQuery);

/**
 * AJAX Basket Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */ (function ($) {

    //Extends jQuery's namespace
    $.basket = {};

    //Default settings
    $.basket.options = {
        viewport: '',
        basketLoader: '.ajax_basket .ajax_loader',
        basketResult: '.ajax_basket_result',
        basketDisplay: '#shopnavi div.display_basket',
        basketParent: '.ajax_basket_container'
    };

    //Initialize the basket module
    //and binds the needed events
    $.basket.init = function () {
        var width = 660;
        var position = 'fixed';

        if ($.browser.msie && parseInt($.browser.version, 10) === 6) {
            width = width - 10;
            position = 'absolute';
        }


        var modalConfig = {
            'position': position,
            'animationSpeed': 200,
            'width': width + 'px',
            'textContainer': '<div>',
            'textClass': 'ajax_add_article_container'
        };
        var sliderConfig = {
            'headline': false,
            'navigation': false,
            'scrollSpeed': 800,
            'rotate': false,
            'showArrows': true,
            'width': 630,
            'height': 210,
            'scrollWidth': 578,
            'containerCSS': {
                'margin': '0 0 15px 15px'
            }
        };

        $('a.buynow').live('click', function (event) {
            event.preventDefault();

            $.loadingIndicator.open();
            $.ajax({
                'dataType': 'jsonp',
                'url': $(this).attr('href'),
                'data': {
                    isXHR: 1
                },
                'success': function (result) {
                    $.loadingIndicator.close();
                    $.modal(result, '', modalConfig);
                    $('#lbOverlay').css('opacity', '0').show().fadeTo('fast', '0.3');

                    $('.slider_modal').ajaxSlider('locale', sliderConfig);

                    $('.modal .close').hide();
                    $.basket.refreshDisplay();
                }
            });
        });
        $('.basketform').bind('submit', function (event) {
            event.preventDefault();

            $.loadingIndicator.open();
            $.ajax({
                'data': $(this).serialize() + '&isXHR=1',
                'dataType': 'jsonp',
                'url': $(this).attr('action'),
                'success': function (result) {

                    $.loadingIndicator.close();
                    $.modal(result, '', modalConfig);
                    $('#lbOverlay').css('opacity', '0').show().fadeTo('fast', '0.3');

                    $('.slider_modal').ajaxSlider('locale', sliderConfig);

                    $('.modal .close').hide();
                    $.basket.refreshDisplay();
                }
            });
        });
    };

    //Refreshs the basket display
    $.basket.refreshDisplay = function () {
        $.ajax({
            'dataType': 'jsonp',
            'url': $.basket.options.viewport,
            'data': {
                'sAction': 'ajaxAmount'
            },
            'success': function (result) {
                $($.basket.options.basketDisplay).html(result);
            }
        });
    };

    //Requests the basket content
    $.basket.getBasket = function () {
        if (!$($.basket.options.basketResult).length) {
            $('<div>', {
                'class': 'ajax_basket_result'
            }).appendTo(document.body);
        }
        $($.basket.options.basketLoader).show();
        $.ajax({
            'data': {
                'sAction': 'ajaxCart'
            },
            'dataType': 'jsonp',
            'url': $.basket.options.viewport,
            'success': function (result) {
                var offset = $($.basket.options.basketParent).offset();
                $($.basket.options.basketResult).css({
                    'top': offset.top + 22,
                    'left': offset.left - ($($.basket.options.basketResult).width() - $($.basket.options.basketParent).width() + 20)
                });
                $($.basket.options.basketLoader).hide();
                if (result.length) {
                    $($.basket.options.basketResult).empty().html(result);
                } else {
                    $($.basket.options.basketResult).empty().html($.basket.options.emptyText);
                }
                $($.basket.options.basketResult).addClass('active').slideDown('fast');
                $(document.body).bind('click.basket', function () {
                    $($.basket.options.basketResult).removeClass('active').slideUp('fast');
                    //$(document.body).unbind('click.basket');
                });
            }
        });
    };
})(jQuery);

/**
 * Topseller Accordion Plugin
 * for Shopware
 *
 * Shopware AG (c) 2010
 */ (function ($) {

    //Extends jQuery's function namespace
    $.fn.kwicks = function (n) {
        var p = {
            isVertical: true,
            sticky: false,
            defaultKwick: 0,
            event: 'mouseover',
            spacing: 0,
            duration: 500
        };
        var o = $.extend(p, n);
        var q = (o.isVertical ? 'height' : 'width');
        var r = (o.isVertical ? 'top' : 'left');
        return this.each(function () {
            $(this).parent().show();
            container = $(this);
            var k = container.children('li');
            //var l = k.eq(0).css(q).replace(/px/, '');
            var l = 0;
            k.each(function (i) {
                l += Math.floor($(this).css(q).replace(/px/, ''));
            });
            l /= k.size();

            if (!o.max) {
                o.max = (l * k.size()) - (o.min * (k.size() - 1));
            } else {
                o.min = ((l * k.size()) - o.max) / (k.size() - 1);
            }
            if (o.isVertical) {
                container.css({
                    width: k.eq(0).css('width'),
                    height: (l * k.size()) + (o.spacing * (k.size() - 1)) + 'px'
                });
            } else {
                container.css({
                    width: (l * k.size()) + (o.spacing * (k.size() - 1)) + 'px',
                    height: k.eq(0).css('height')
                });
            }
            var m = [];
            for (i = 0; i < k.size(); i++) {
                m[i] = [];
                for (j = 1; j < k.size() - 1; j++) {
                    if (i === j) {
                        m[i][j] = o.isVertical ? j * o.min + (j * o.spacing) : j * o.min + (j * o.spacing);
                    } else {
                        m[i][j] = (j <= i ? (j * o.min) : (j - 1) * o.min + o.max) + (j * o.spacing);
                    }
                }
            }
            k.each(function (i) {
                var h = $(this);
                if (i === 0) {
                    h.css(r, '0px');
                } else if (i === k.size() - 1) {
                    h.css(o.isVertical ? 'bottom' : 'right', '0px');
                } else {
                    if (o.sticky) {
                        h.css(r, m[o.defaultKwick][i]);
                    } else {
                        h.css(r, (i * l) + (i * o.spacing));
                    }
                }
                if (o.sticky) {
                    if (o.defaultKwick === i) {
                        h.css(q, o.max + 'px');
                        h.addClass('active');
                    } else {
                        h.css(q, o.min + 'px');
                    }
                }
                h.css({
                    margin: 0,
                    position: 'absolute'
                });
                h.bind(o.event, function () {
                    var c = [];
                    var d = [];
                    k.stop().removeClass('active');
                    for (j = 0; j < k.size(); j++) {
                        c[j] = k.eq(j).css(q).replace(/px/, '');
                        d[j] = k.eq(j).css(r).replace(/px/, '');
                    }
                    var e = {};
                    e[q] = o.max;
                    var f = o.max - c[i];
                    var g = c[i] / f;
                    h.addClass('active').animate(e, {
                        step: function (a) {
                            var b = f !== 0 ? a / f - g : 1;
                            k.each(function (j) {
                                if (j !== i) {
                                    k.eq(j).css(q, c[j] - ((c[j] - o.min) * b) + 'px');
                                }
                                if (j > 0 && j < k.size() - 1) {
                                    k.eq(j).css(r, d[j] - ((d[j] - m[i][j]) * b) + 'px');
                                }
                            });
                        },
                        duration: o.duration,
                        easing: o.easing
                    });
                });
            });
            if (!o.sticky) {
                container.bind("mouseleave", function () {
                    var c = [];
                    var d = [];
                    k.removeClass('active').stop();
                    for (i = 0; i < k.size(); i++) {
                        c[i] = k.eq(i).css(q).replace(/px/, '');
                        d[i] = k.eq(i).css(r).replace(/px/, '');
                    }
                    var e = {};
                    e[q] = l;
                    var f = l - c[0];
                    k.eq(0).animate(e, {
                        step: function (a) {
                            var b = f !== 0 ? (a - c[0]) / f : 1;
                            for (i = 1; i < k.size(); i++) {
                                k.eq(i).css(q, c[i] - ((c[i] - l) * b) + 'px');
                                if (i < k.size() - 1) {
                                    k.eq(i).css(r, d[i] - ((d[i] - ((i * l) + (i * o.spacing))) * b) + 'px');
                                }
                            }
                        },
                        duration: o.duration,
                        easing: o.easing
                    });
                });
            }
        });
    };
})(jQuery);

/**
 * Supplier Filter
 * for Shopware
 *
 * Shopware AG (c) 2010
 */ (function ($) {

    //Default setttings
    var config = {
        slideContainer: '.supplier_filter .slideContainer',
        plus: '.filter_actions .plus',
        plusText: '+',
        minus: '.filter_actions .minus',
        minusText: '-',
        expander: '.expandcollapse',
        expandAll: '.supplier_filter div .expandcollapse',
        activeClass: 'active',
        animationSpeed: 'fast'
    };

    $.fn.supplierfilter = function (settings) {

        //Extends default settings with user settings
        if (settings) {
            $.extend(config, settings);
        }

        this.each(function () {

            //Hides the container on start up
            if($(this).find('li').hasClass(config.activeClass)) {
                $(this).show();
            } else {
                $(this).hide();
            }

            //Bind click event on span
            $(this).prev('div').bind('click', function () {
                $(this).toggleClass(config.activeClass).next('.slideContainer').slideToggle(config.animationSpeed);
                if($(this).hasClass(config.activeClass)) {
                    $(this).children(config.expander).text(config.minusText);
                } else {
                    $(this).children(config.expander).text(config.plusText);
                }
            });
        });

        return this;
    };

})(jQuery);

/*! jQuery UI - v1.8.20 - 2012-04-30
 * https://github.com/jquery/jquery-ui
 * Includes: jquery.ui.core.js
 * Copyright (c) 2012 AUTHORS.txt; Licensed MIT, GPL */
(function(a,b){function c(b,c){var e=b.nodeName.toLowerCase();if("area"===e){var f=b.parentNode,g=f.name,h;return!b.href||!g||f.nodeName.toLowerCase()!=="map"?!1:(h=a("img[usemap=#"+g+"]")[0],!!h&&d(h))}return(/input|select|textarea|button|object/.test(e)?!b.disabled:"a"==e?b.href||c:c)&&d(b)}function d(b){return!a(b).parents().andSelf().filter(function(){return a.curCSS(this,"visibility")==="hidden"||a.expr.filters.hidden(this)}).length}a.ui=a.ui||{};if(a.ui.version)return;a.extend(a.ui,{version:"1.8.20",keyCode:{ALT:18,BACKSPACE:8,CAPS_LOCK:20,COMMA:188,COMMAND:91,COMMAND_LEFT:91,COMMAND_RIGHT:93,CONTROL:17,DELETE:46,DOWN:40,END:35,ENTER:13,ESCAPE:27,HOME:36,INSERT:45,LEFT:37,MENU:93,NUMPAD_ADD:107,NUMPAD_DECIMAL:110,NUMPAD_DIVIDE:111,NUMPAD_ENTER:108,NUMPAD_MULTIPLY:106,NUMPAD_SUBTRACT:109,PAGE_DOWN:34,PAGE_UP:33,PERIOD:190,RIGHT:39,SHIFT:16,SPACE:32,TAB:9,UP:38,WINDOWS:91}}),a.fn.extend({propAttr:a.fn.prop||a.fn.attr,_focus:a.fn.focus,focus:function(b,c){return typeof b=="number"?this.each(function(){var d=this;setTimeout(function(){a(d).focus(),c&&c.call(d)},b)}):this._focus.apply(this,arguments)},scrollParent:function(){var b;return a.browser.msie&&/(static|relative)/.test(this.css("position"))||/absolute/.test(this.css("position"))?b=this.parents().filter(function(){return/(relative|absolute|fixed)/.test(a.curCSS(this,"position",1))&&/(auto|scroll)/.test(a.curCSS(this,"overflow",1)+a.curCSS(this,"overflow-y",1)+a.curCSS(this,"overflow-x",1))}).eq(0):b=this.parents().filter(function(){return/(auto|scroll)/.test(a.curCSS(this,"overflow",1)+a.curCSS(this,"overflow-y",1)+a.curCSS(this,"overflow-x",1))}).eq(0),/fixed/.test(this.css("position"))||!b.length?a(document):b},zIndex:function(c){if(c!==b)return this.css("zIndex",c);if(this.length){var d=a(this[0]),e,f;while(d.length&&d[0]!==document){e=d.css("position");if(e==="absolute"||e==="relative"||e==="fixed"){f=parseInt(d.css("zIndex"),10);if(!isNaN(f)&&f!==0)return f}d=d.parent()}}return 0},disableSelection:function(){return this.bind((a.support.selectstart?"selectstart":"mousedown")+".ui-disableSelection",function(a){a.preventDefault()})},enableSelection:function(){return this.unbind(".ui-disableSelection")}}),a.each(["Width","Height"],function(c,d){function h(b,c,d,f){return a.each(e,function(){c-=parseFloat(a.curCSS(b,"padding"+this,!0))||0,d&&(c-=parseFloat(a.curCSS(b,"border"+this+"Width",!0))||0),f&&(c-=parseFloat(a.curCSS(b,"margin"+this,!0))||0)}),c}var e=d==="Width"?["Left","Right"]:["Top","Bottom"],f=d.toLowerCase(),g={innerWidth:a.fn.innerWidth,innerHeight:a.fn.innerHeight,outerWidth:a.fn.outerWidth,outerHeight:a.fn.outerHeight};a.fn["inner"+d]=function(c){return c===b?g["inner"+d].call(this):this.each(function(){a(this).css(f,h(this,c)+"px")})},a.fn["outer"+d]=function(b,c){return typeof b!="number"?g["outer"+d].call(this,b):this.each(function(){a(this).css(f,h(this,b,!0,c)+"px")})}}),a.extend(a.expr[":"],{data:function(b,c,d){return!!a.data(b,d[3])},focusable:function(b){return c(b,!isNaN(a.attr(b,"tabindex")))},tabbable:function(b){var d=a.attr(b,"tabindex"),e=isNaN(d);return(e||d>=0)&&c(b,!e)}}),a(function(){var b=document.body,c=b.appendChild(c=document.createElement("div"));c.offsetHeight,a.extend(c.style,{minHeight:"100px",height:"auto",padding:0,borderWidth:0}),a.support.minHeight=c.offsetHeight===100,a.support.selectstart="onselectstart"in c,b.removeChild(c).style.display="none"}),a.extend(a.ui,{plugin:{add:function(b,c,d){var e=a.ui[b].prototype;for(var f in d)e.plugins[f]=e.plugins[f]||[],e.plugins[f].push([c,d[f]])},call:function(a,b,c){var d=a.plugins[b];if(!d||!a.element[0].parentNode)return;for(var e=0;e<d.length;e++)a.options[d[e][0]]&&d[e][1].apply(a.element,c)}},contains:function(a,b){return document.compareDocumentPosition?a.compareDocumentPosition(b)&16:a!==b&&a.contains(b)},hasScroll:function(b,c){if(a(b).css("overflow")==="hidden")return!1;var d=c&&c==="left"?"scrollLeft":"scrollTop",e=!1;return b[d]>0?!0:(b[d]=1,e=b[d]>0,b[d]=0,e)},isOverAxis:function(a,b,c){return a>b&&a<b+c},isOver:function(b,c,d,e,f,g){return a.ui.isOverAxis(b,d,f)&&a.ui.isOverAxis(c,e,g)}})})(jQuery);;/*! jQuery UI - v1.8.20 - 2012-04-30
 * https://github.com/jquery/jquery-ui
 * Includes: jquery.ui.widget.js
 * Copyright (c) 2012 AUTHORS.txt; Licensed MIT, GPL */
(function(a,b){if(a.cleanData){var c=a.cleanData;a.cleanData=function(b){for(var d=0,e;(e=b[d])!=null;d++)try{a(e).triggerHandler("remove")}catch(f){}c(b)}}else{var d=a.fn.remove;a.fn.remove=function(b,c){return this.each(function(){return c||(!b||a.filter(b,[this]).length)&&a("*",this).add([this]).each(function(){try{a(this).triggerHandler("remove")}catch(b){}}),d.call(a(this),b,c)})}}a.widget=function(b,c,d){var e=b.split(".")[0],f;b=b.split(".")[1],f=e+"-"+b,d||(d=c,c=a.Widget),a.expr[":"][f]=function(c){return!!a.data(c,b)},a[e]=a[e]||{},a[e][b]=function(a,b){arguments.length&&this._createWidget(a,b)};var g=new c;g.options=a.extend(!0,{},g.options),a[e][b].prototype=a.extend(!0,g,{namespace:e,widgetName:b,widgetEventPrefix:a[e][b].prototype.widgetEventPrefix||b,widgetBaseClass:f},d),a.widget.bridge(b,a[e][b])},a.widget.bridge=function(c,d){a.fn[c]=function(e){var f=typeof e=="string",g=Array.prototype.slice.call(arguments,1),h=this;return e=!f&&g.length?a.extend.apply(null,[!0,e].concat(g)):e,f&&e.charAt(0)==="_"?h:(f?this.each(function(){var d=a.data(this,c),f=d&&a.isFunction(d[e])?d[e].apply(d,g):d;if(f!==d&&f!==b)return h=f,!1}):this.each(function(){var b=a.data(this,c);b?b.option(e||{})._init():a.data(this,c,new d(e,this))}),h)}},a.Widget=function(a,b){arguments.length&&this._createWidget(a,b)},a.Widget.prototype={widgetName:"widget",widgetEventPrefix:"",options:{disabled:!1},_createWidget:function(b,c){a.data(c,this.widgetName,this),this.element=a(c),this.options=a.extend(!0,{},this.options,this._getCreateOptions(),b);var d=this;this.element.bind("remove."+this.widgetName,function(){d.destroy()}),this._create(),this._trigger("create"),this._init()},_getCreateOptions:function(){return a.metadata&&a.metadata.get(this.element[0])[this.widgetName]},_create:function(){},_init:function(){},destroy:function(){this.element.unbind("."+this.widgetName).removeData(this.widgetName),this.widget().unbind("."+this.widgetName).removeAttr("aria-disabled").removeClass(this.widgetBaseClass+"-disabled "+"ui-state-disabled")},widget:function(){return this.element},option:function(c,d){var e=c;if(arguments.length===0)return a.extend({},this.options);if(typeof c=="string"){if(d===b)return this.options[c];e={},e[c]=d}return this._setOptions(e),this},_setOptions:function(b){var c=this;return a.each(b,function(a,b){c._setOption(a,b)}),this},_setOption:function(a,b){return this.options[a]=b,a==="disabled"&&this.widget()[b?"addClass":"removeClass"](this.widgetBaseClass+"-disabled"+" "+"ui-state-disabled").attr("aria-disabled",b),this},enable:function(){return this._setOption("disabled",!1)},disable:function(){return this._setOption("disabled",!0)},_trigger:function(b,c,d){var e,f,g=this.options[b];d=d||{},c=a.Event(c),c.type=(b===this.widgetEventPrefix?b:this.widgetEventPrefix+b).toLowerCase(),c.target=this.element[0],f=c.originalEvent;if(f)for(e in f)e in c||(c[e]=f[e]);return this.element.trigger(c,d),!(a.isFunction(g)&&g.call(this.element[0],c,d)===!1||c.isDefaultPrevented())}}})(jQuery);;/*! jQuery UI - v1.8.20 - 2012-04-30
 * https://github.com/jquery/jquery-ui
 * Includes: jquery.ui.tabs.js
 * Copyright (c) 2012 AUTHORS.txt; Licensed MIT, GPL */
(function(a,b){function e(){return++c}function f(){return++d}var c=0,d=0;a.widget("ui.tabs",{options:{add:null,ajaxOptions:null,cache:!1,cookie:null,collapsible:!1,disable:null,disabled:[],enable:null,event:"click",fx:null,idPrefix:"ui-tabs-",load:null,panelTemplate:"<div></div>",remove:null,select:null,show:null,spinner:"<em>Loading&#8230;</em>",tabTemplate:"<li><a href='#{href}'><span>#{label}</span></a></li>"},_create:function(){this._tabify(!0)},_setOption:function(a,b){if(a=="selected"){if(this.options.collapsible&&b==this.options.selected)return;this.select(b)}else this.options[a]=b,this._tabify()},_tabId:function(a){return a.title&&a.title.replace(/\s/g,"_").replace(/[^\w\u00c0-\uFFFF-]/g,"")||this.options.idPrefix+e()},_sanitizeSelector:function(a){return a.replace(/:/g,"\\:")},_cookie:function(){var b=this.cookie||(this.cookie=this.options.cookie.name||"ui-tabs-"+f());return a.cookie.apply(null,[b].concat(a.makeArray(arguments)))},_ui:function(a,b){return{tab:a,panel:b,index:this.anchors.index(a)}},_cleanup:function(){this.lis.filter(".ui-state-processing").removeClass("ui-state-processing").find("span:data(label.tabs)").each(function(){var b=a(this);b.html(b.data("label.tabs")).removeData("label.tabs")})},_tabify:function(c){function m(b,c){b.css("display",""),!a.support.opacity&&c.opacity&&b[0].style.removeAttribute("filter")}var d=this,e=this.options,f=/^#.+/;this.list=this.element.find("ol,ul").eq(0),this.lis=a(" > li:has(a[href])",this.list),this.anchors=this.lis.map(function(){return a("a",this)[0]}),this.panels=a([]),this.anchors.each(function(b,c){var g=a(c).attr("href"),h=g.split("#")[0],i;h&&(h===location.toString().split("#")[0]||(i=a("base")[0])&&h===i.href)&&(g=c.hash,c.href=g);if(f.test(g))d.panels=d.panels.add(d.element.find(d._sanitizeSelector(g)));else if(g&&g!=="#"){a.data(c,"href.tabs",g),a.data(c,"load.tabs",g.replace(/#.*$/,""));var j=d._tabId(c);c.href="#"+j;var k=d.element.find("#"+j);k.length||(k=a(e.panelTemplate).attr("id",j).addClass("ui-tabs-panel ui-widget-content ui-corner-bottom").insertAfter(d.panels[b-1]||d.list),k.data("destroy.tabs",!0)),d.panels=d.panels.add(k)}else e.disabled.push(b)}),c?(this.element.addClass("ui-tabs ui-widget ui-widget-content ui-corner-all"),this.list.addClass("ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all"),this.lis.addClass("ui-state-default ui-corner-top"),this.panels.addClass("ui-tabs-panel ui-widget-content ui-corner-bottom"),e.selected===b?(location.hash&&this.anchors.each(function(a,b){if(b.hash==location.hash)return e.selected=a,!1}),typeof e.selected!="number"&&e.cookie&&(e.selected=parseInt(d._cookie(),10)),typeof e.selected!="number"&&this.lis.filter(".ui-tabs-selected").length&&(e.selected=this.lis.index(this.lis.filter(".ui-tabs-selected"))),e.selected=e.selected||(this.lis.length?0:-1)):e.selected===null&&(e.selected=-1),e.selected=e.selected>=0&&this.anchors[e.selected]||e.selected<0?e.selected:0,e.disabled=a.unique(e.disabled.concat(a.map(this.lis.filter(".ui-state-disabled"),function(a,b){return d.lis.index(a)}))).sort(),a.inArray(e.selected,e.disabled)!=-1&&e.disabled.splice(a.inArray(e.selected,e.disabled),1),this.panels.addClass("ui-tabs-hide"),this.lis.removeClass("ui-tabs-selected ui-state-active"),e.selected>=0&&this.anchors.length&&(d.element.find(d._sanitizeSelector(d.anchors[e.selected].hash)).removeClass("ui-tabs-hide"),this.lis.eq(e.selected).addClass("ui-tabs-selected ui-state-active"),d.element.queue("tabs",function(){d._trigger("show",null,d._ui(d.anchors[e.selected],d.element.find(d._sanitizeSelector(d.anchors[e.selected].hash))[0]))}),this.load(e.selected)),a(window).bind("unload",function(){d.lis.add(d.anchors).unbind(".tabs"),d.lis=d.anchors=d.panels=null})):e.selected=this.lis.index(this.lis.filter(".ui-tabs-selected")),this.element[e.collapsible?"addClass":"removeClass"]("ui-tabs-collapsible"),e.cookie&&this._cookie(e.selected,e.cookie);for(var g=0,h;h=this.lis[g];g++)a(h)[a.inArray(g,e.disabled)!=-1&&!a(h).hasClass("ui-tabs-selected")?"addClass":"removeClass"]("ui-state-disabled");e.cache===!1&&this.anchors.removeData("cache.tabs"),this.lis.add(this.anchors).unbind(".tabs");if(e.event!=="mouseover"){var i=function(a,b){b.is(":not(.ui-state-disabled)")&&b.addClass("ui-state-"+a)},j=function(a,b){b.removeClass("ui-state-"+a)};this.lis.bind("mouseover.tabs",function(){i("hover",a(this))}),this.lis.bind("mouseout.tabs",function(){j("hover",a(this))}),this.anchors.bind("focus.tabs",function(){i("focus",a(this).closest("li"))}),this.anchors.bind("blur.tabs",function(){j("focus",a(this).closest("li"))})}var k,l;e.fx&&(a.isArray(e.fx)?(k=e.fx[0],l=e.fx[1]):k=l=e.fx);var n=l?function(b,c){a(b).closest("li").addClass("ui-tabs-selected ui-state-active"),c.hide().removeClass("ui-tabs-hide").animate(l,l.duration||"normal",function(){m(c,l),d._trigger("show",null,d._ui(b,c[0]))})}:function(b,c){a(b).closest("li").addClass("ui-tabs-selected ui-state-active"),c.removeClass("ui-tabs-hide"),d._trigger("show",null,d._ui(b,c[0]))},o=k?function(a,b){b.animate(k,k.duration||"normal",function(){d.lis.removeClass("ui-tabs-selected ui-state-active"),b.addClass("ui-tabs-hide"),m(b,k),d.element.dequeue("tabs")})}:function(a,b,c){d.lis.removeClass("ui-tabs-selected ui-state-active"),b.addClass("ui-tabs-hide"),d.element.dequeue("tabs")};this.anchors.bind(e.event+".tabs",function(){var b=this,c=a(b).closest("li"),f=d.panels.filter(":not(.ui-tabs-hide)"),g=d.element.find(d._sanitizeSelector(b.hash));if(c.hasClass("ui-tabs-selected")&&!e.collapsible||c.hasClass("ui-state-disabled")||c.hasClass("ui-state-processing")||d.panels.filter(":animated").length||d._trigger("select",null,d._ui(this,g[0]))===!1)return this.blur(),!1;e.selected=d.anchors.index(this),d.abort();if(e.collapsible){if(c.hasClass("ui-tabs-selected"))return e.selected=-1,e.cookie&&d._cookie(e.selected,e.cookie),d.element.queue("tabs",function(){o(b,f)}).dequeue("tabs"),this.blur(),!1;if(!f.length)return e.cookie&&d._cookie(e.selected,e.cookie),d.element.queue("tabs",function(){n(b,g)}),d.load(d.anchors.index(this)),this.blur(),!1}e.cookie&&d._cookie(e.selected,e.cookie);if(g.length)f.length&&d.element.queue("tabs",function(){o(b,f)}),d.element.queue("tabs",function(){n(b,g)}),d.load(d.anchors.index(this));else throw"jQuery UI Tabs: Mismatching fragment identifier.";a.browser.msie&&this.blur()}),this.anchors.bind("click.tabs",function(){return!1})},_getIndex:function(a){return typeof a=="string"&&(a=this.anchors.index(this.anchors.filter("[href$='"+a+"']"))),a},destroy:function(){var b=this.options;return this.abort(),this.element.unbind(".tabs").removeClass("ui-tabs ui-widget ui-widget-content ui-corner-all ui-tabs-collapsible").removeData("tabs"),this.list.removeClass("ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all"),this.anchors.each(function(){var b=a.data(this,"href.tabs");b&&(this.href=b);var c=a(this).unbind(".tabs");a.each(["href","load","cache"],function(a,b){c.removeData(b+".tabs")})}),this.lis.unbind(".tabs").add(this.panels).each(function(){a.data(this,"destroy.tabs")?a(this).remove():a(this).removeClass(["ui-state-default","ui-corner-top","ui-tabs-selected","ui-state-active","ui-state-hover","ui-state-focus","ui-state-disabled","ui-tabs-panel","ui-widget-content","ui-corner-bottom","ui-tabs-hide"].join(" "))}),b.cookie&&this._cookie(null,b.cookie),this},add:function(c,d,e){e===b&&(e=this.anchors.length);var f=this,g=this.options,h=a(g.tabTemplate.replace(/#\{href\}/g,c).replace(/#\{label\}/g,d)),i=c.indexOf("#")?this._tabId(a("a",h)[0]):c.replace("#","");h.addClass("ui-state-default ui-corner-top").data("destroy.tabs",!0);var j=f.element.find("#"+i);return j.length||(j=a(g.panelTemplate).attr("id",i).data("destroy.tabs",!0)),j.addClass("ui-tabs-panel ui-widget-content ui-corner-bottom ui-tabs-hide"),e>=this.lis.length?(h.appendTo(this.list),j.appendTo(this.list[0].parentNode)):(h.insertBefore(this.lis[e]),j.insertBefore(this.panels[e])),g.disabled=a.map(g.disabled,function(a,b){return a>=e?++a:a}),this._tabify(),this.anchors.length==1&&(g.selected=0,h.addClass("ui-tabs-selected ui-state-active"),j.removeClass("ui-tabs-hide"),this.element.queue("tabs",function(){f._trigger("show",null,f._ui(f.anchors[0],f.panels[0]))}),this.load(0)),this._trigger("add",null,this._ui(this.anchors[e],this.panels[e])),this},remove:function(b){b=this._getIndex(b);var c=this.options,d=this.lis.eq(b).remove(),e=this.panels.eq(b).remove();return d.hasClass("ui-tabs-selected")&&this.anchors.length>1&&this.select(b+(b+1<this.anchors.length?1:-1)),c.disabled=a.map(a.grep(c.disabled,function(a,c){return a!=b}),function(a,c){return a>=b?--a:a}),this._tabify(),this._trigger("remove",null,this._ui(d.find("a")[0],e[0])),this},enable:function(b){b=this._getIndex(b);var c=this.options;if(a.inArray(b,c.disabled)==-1)return;return this.lis.eq(b).removeClass("ui-state-disabled"),c.disabled=a.grep(c.disabled,function(a,c){return a!=b}),this._trigger("enable",null,this._ui(this.anchors[b],this.panels[b])),this},disable:function(a){a=this._getIndex(a);var b=this,c=this.options;return a!=c.selected&&(this.lis.eq(a).addClass("ui-state-disabled"),c.disabled.push(a),c.disabled.sort(),this._trigger("disable",null,this._ui(this.anchors[a],this.panels[a]))),this},select:function(a){a=this._getIndex(a);if(a==-1)if(this.options.collapsible&&this.options.selected!=-1)a=this.options.selected;else return this;return this.anchors.eq(a).trigger(this.options.event+".tabs"),this},load:function(b){b=this._getIndex(b);var c=this,d=this.options,e=this.anchors.eq(b)[0],f=a.data(e,"load.tabs");this.abort();if(!f||this.element.queue("tabs").length!==0&&a.data(e,"cache.tabs")){this.element.dequeue("tabs");return}this.lis.eq(b).addClass("ui-state-processing");if(d.spinner){var g=a("span",e);g.data("label.tabs",g.html()).html(d.spinner)}return this.xhr=a.ajax(a.extend({},d.ajaxOptions,{url:f,success:function(f,g){c.element.find(c._sanitizeSelector(e.hash)).html(f),c._cleanup(),d.cache&&a.data(e,"cache.tabs",!0),c._trigger("load",null,c._ui(c.anchors[b],c.panels[b]));try{d.ajaxOptions.success(f,g)}catch(h){}},error:function(a,f,g){c._cleanup(),c._trigger("load",null,c._ui(c.anchors[b],c.panels[b]));try{d.ajaxOptions.error(a,f,b,e)}catch(g){}}})),c.element.dequeue("tabs"),this},abort:function(){return this.element.queue([]),this.panels.stop(!1,!0),this.element.queue("tabs",this.element.queue("tabs").splice(-2,2)),this.xhr&&(this.xhr.abort(),delete this.xhr),this._cleanup(),this},url:function(a,b){return this.anchors.eq(a).removeData("cache.tabs").data("load.tabs",b),this},length:function(){return this.anchors.length}}),a.extend(a.ui.tabs,{version:"1.8.20"}),a.extend(a.ui.tabs.prototype,{rotation:null,rotate:function(a,b){var c=this,d=this.options,e=c._rotate||(c._rotate=function(b){clearTimeout(c.rotation),c.rotation=setTimeout(function(){var a=d.selected;c.select(++a<c.anchors.length?a:0)},a),b&&b.stopPropagation()}),f=c._unrotate||(c._unrotate=b?function(a){e()}:function(a){a.clientX&&c.rotate(null)});return a?(this.element.bind("tabsshow",e),this.anchors.bind(d.event+".tabs",f),e()):(clearTimeout(c.rotation),this.element.unbind("tabsshow",e),this.anchors.unbind(d.event+".tabs",f),delete this._rotate,delete this._unrotate),this}})})(jQuery);;/*! jQuery UI - v1.8.20 - 2012-04-30
 * https://github.com/jquery/jquery-ui
 * Includes: jquery.effects.core.js
 * Copyright (c) 2012 AUTHORS.txt; Licensed MIT, GPL */
jQuery.effects||function(a,b){function c(b){var c;return b&&b.constructor==Array&&b.length==3?b:(c=/rgb\(\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*,\s*([0-9]{1,3})\s*\)/.exec(b))?[parseInt(c[1],10),parseInt(c[2],10),parseInt(c[3],10)]:(c=/rgb\(\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*,\s*([0-9]+(?:\.[0-9]+)?)\%\s*\)/.exec(b))?[parseFloat(c[1])*2.55,parseFloat(c[2])*2.55,parseFloat(c[3])*2.55]:(c=/#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(b))?[parseInt(c[1],16),parseInt(c[2],16),parseInt(c[3],16)]:(c=/#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(b))?[parseInt(c[1]+c[1],16),parseInt(c[2]+c[2],16),parseInt(c[3]+c[3],16)]:(c=/rgba\(0, 0, 0, 0\)/.exec(b))?e.transparent:e[a.trim(b).toLowerCase()]}function d(b,d){var e;do{e=a.curCSS(b,d);if(e!=""&&e!="transparent"||a.nodeName(b,"body"))break;d="backgroundColor"}while(b=b.parentNode);return c(e)}function h(){var a=document.defaultView?document.defaultView.getComputedStyle(this,null):this.currentStyle,b={},c,d;if(a&&a.length&&a[0]&&a[a[0]]){var e=a.length;while(e--)c=a[e],typeof a[c]=="string"&&(d=c.replace(/\-(\w)/g,function(a,b){return b.toUpperCase()}),b[d]=a[c])}else for(c in a)typeof a[c]=="string"&&(b[c]=a[c]);return b}function i(b){var c,d;for(c in b)d=b[c],(d==null||a.isFunction(d)||c in g||/scrollbar/.test(c)||!/color/i.test(c)&&isNaN(parseFloat(d)))&&delete b[c];return b}function j(a,b){var c={_:0},d;for(d in b)a[d]!=b[d]&&(c[d]=b[d]);return c}function k(b,c,d,e){typeof b=="object"&&(e=c,d=null,c=b,b=c.effect),a.isFunction(c)&&(e=c,d=null,c={});if(typeof c=="number"||a.fx.speeds[c])e=d,d=c,c={};return a.isFunction(d)&&(e=d,d=null),c=c||{},d=d||c.duration,d=a.fx.off?0:typeof d=="number"?d:d in a.fx.speeds?a.fx.speeds[d]:a.fx.speeds._default,e=e||c.complete,[b,c,d,e]}function l(b){return!b||typeof b=="number"||a.fx.speeds[b]?!0:typeof b=="string"&&!a.effects[b]?!0:!1}a.effects={},a.each(["backgroundColor","borderBottomColor","borderLeftColor","borderRightColor","borderTopColor","borderColor","color","outlineColor"],function(b,e){a.fx.step[e]=function(a){a.colorInit||(a.start=d(a.elem,e),a.end=c(a.end),a.colorInit=!0),a.elem.style[e]="rgb("+Math.max(Math.min(parseInt(a.pos*(a.end[0]-a.start[0])+a.start[0],10),255),0)+","+Math.max(Math.min(parseInt(a.pos*(a.end[1]-a.start[1])+a.start[1],10),255),0)+","+Math.max(Math.min(parseInt(a.pos*(a.end[2]-a.start[2])+a.start[2],10),255),0)+")"}});var e={aqua:[0,255,255],azure:[240,255,255],beige:[245,245,220],black:[0,0,0],blue:[0,0,255],brown:[165,42,42],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgrey:[169,169,169],darkgreen:[0,100,0],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkviolet:[148,0,211],fuchsia:[255,0,255],gold:[255,215,0],green:[0,128,0],indigo:[75,0,130],khaki:[240,230,140],lightblue:[173,216,230],lightcyan:[224,255,255],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightyellow:[255,255,224],lime:[0,255,0],magenta:[255,0,255],maroon:[128,0,0],navy:[0,0,128],olive:[128,128,0],orange:[255,165,0],pink:[255,192,203],purple:[128,0,128],violet:[128,0,128],red:[255,0,0],silver:[192,192,192],white:[255,255,255],yellow:[255,255,0],transparent:[255,255,255]},f=["add","remove","toggle"],g={border:1,borderBottom:1,borderColor:1,borderLeft:1,borderRight:1,borderTop:1,borderWidth:1,margin:1,padding:1};a.effects.animateClass=function(b,c,d,e){return a.isFunction(d)&&(e=d,d=null),this.queue(function(){var g=a(this),k=g.attr("style")||" ",l=i(h.call(this)),m,n=g.attr("class")||"";a.each(f,function(a,c){b[c]&&g[c+"Class"](b[c])}),m=i(h.call(this)),g.attr("class",n),g.animate(j(l,m),{queue:!1,duration:c,easing:d,complete:function(){a.each(f,function(a,c){b[c]&&g[c+"Class"](b[c])}),typeof g.attr("style")=="object"?(g.attr("style").cssText="",g.attr("style").cssText=k):g.attr("style",k),e&&e.apply(this,arguments),a.dequeue(this)}})})},a.fn.extend({_addClass:a.fn.addClass,addClass:function(b,c,d,e){return c?a.effects.animateClass.apply(this,[{add:b},c,d,e]):this._addClass(b)},_removeClass:a.fn.removeClass,removeClass:function(b,c,d,e){return c?a.effects.animateClass.apply(this,[{remove:b},c,d,e]):this._removeClass(b)},_toggleClass:a.fn.toggleClass,toggleClass:function(c,d,e,f,g){return typeof d=="boolean"||d===b?e?a.effects.animateClass.apply(this,[d?{add:c}:{remove:c},e,f,g]):this._toggleClass(c,d):a.effects.animateClass.apply(this,[{toggle:c},d,e,f])},switchClass:function(b,c,d,e,f){return a.effects.animateClass.apply(this,[{add:c,remove:b},d,e,f])}}),a.extend(a.effects,{version:"1.8.20",save:function(a,b){for(var c=0;c<b.length;c++)b[c]!==null&&a.data("ec.storage."+b[c],a[0].style[b[c]])},restore:function(a,b){for(var c=0;c<b.length;c++)b[c]!==null&&a.css(b[c],a.data("ec.storage."+b[c]))},setMode:function(a,b){return b=="toggle"&&(b=a.is(":hidden")?"show":"hide"),b},getBaseline:function(a,b){var c,d;switch(a[0]){case"top":c=0;break;case"middle":c=.5;break;case"bottom":c=1;break;default:c=a[0]/b.height}switch(a[1]){case"left":d=0;break;case"center":d=.5;break;case"right":d=1;break;default:d=a[1]/b.width}return{x:d,y:c}},createWrapper:function(b){if(b.parent().is(".ui-effects-wrapper"))return b.parent();var c={width:b.outerWidth(!0),height:b.outerHeight(!0),"float":b.css("float")},d=a("<div></div>").addClass("ui-effects-wrapper").css({fontSize:"100%",background:"transparent",border:"none",margin:0,padding:0}),e=document.activeElement;return b.wrap(d),(b[0]===e||a.contains(b[0],e))&&a(e).focus(),d=b.parent(),b.css("position")=="static"?(d.css({position:"relative"}),b.css({position:"relative"})):(a.extend(c,{position:b.css("position"),zIndex:b.css("z-index")}),a.each(["top","left","bottom","right"],function(a,d){c[d]=b.css(d),isNaN(parseInt(c[d],10))&&(c[d]="auto")}),b.css({position:"relative",top:0,left:0,right:"auto",bottom:"auto"})),d.css(c).show()},removeWrapper:function(b){var c,d=document.activeElement;return b.parent().is(".ui-effects-wrapper")?(c=b.parent().replaceWith(b),(b[0]===d||a.contains(b[0],d))&&a(d).focus(),c):b},setTransition:function(b,c,d,e){return e=e||{},a.each(c,function(a,c){var f=b.cssUnit(c);f[0]>0&&(e[c]=f[0]*d+f[1])}),e}}),a.fn.extend({effect:function(b,c,d,e){var f=k.apply(this,arguments),g={options:f[1],duration:f[2],callback:f[3]},h=g.options.mode,i=a.effects[b];return a.fx.off||!i?h?this[h](g.duration,g.callback):this.each(function(){g.callback&&g.callback.call(this)}):i.call(this,g)},_show:a.fn.show,show:function(a){if(l(a))return this._show.apply(this,arguments);var b=k.apply(this,arguments);return b[1].mode="show",this.effect.apply(this,b)},_hide:a.fn.hide,hide:function(a){if(l(a))return this._hide.apply(this,arguments);var b=k.apply(this,arguments);return b[1].mode="hide",this.effect.apply(this,b)},__toggle:a.fn.toggle,toggle:function(b){if(l(b)||typeof b=="boolean"||a.isFunction(b))return this.__toggle.apply(this,arguments);var c=k.apply(this,arguments);return c[1].mode="toggle",this.effect.apply(this,c)},cssUnit:function(b){var c=this.css(b),d=[];return a.each(["em","px","%","pt"],function(a,b){c.indexOf(b)>0&&(d=[parseFloat(c),b])}),d}}),a.easing.jswing=a.easing.swing,a.extend(a.easing,{def:"easeOutQuad",swing:function(b,c,d,e,f){return a.easing[a.easing.def](b,c,d,e,f)},easeInQuad:function(a,b,c,d,e){return d*(b/=e)*b+c},easeOutQuad:function(a,b,c,d,e){return-d*(b/=e)*(b-2)+c},easeInOutQuad:function(a,b,c,d,e){return(b/=e/2)<1?d/2*b*b+c:-d/2*(--b*(b-2)-1)+c},easeInCubic:function(a,b,c,d,e){return d*(b/=e)*b*b+c},easeOutCubic:function(a,b,c,d,e){return d*((b=b/e-1)*b*b+1)+c},easeInOutCubic:function(a,b,c,d,e){return(b/=e/2)<1?d/2*b*b*b+c:d/2*((b-=2)*b*b+2)+c},easeInQuart:function(a,b,c,d,e){return d*(b/=e)*b*b*b+c},easeOutQuart:function(a,b,c,d,e){return-d*((b=b/e-1)*b*b*b-1)+c},easeInOutQuart:function(a,b,c,d,e){return(b/=e/2)<1?d/2*b*b*b*b+c:-d/2*((b-=2)*b*b*b-2)+c},easeInQuint:function(a,b,c,d,e){return d*(b/=e)*b*b*b*b+c},easeOutQuint:function(a,b,c,d,e){return d*((b=b/e-1)*b*b*b*b+1)+c},easeInOutQuint:function(a,b,c,d,e){return(b/=e/2)<1?d/2*b*b*b*b*b+c:d/2*((b-=2)*b*b*b*b+2)+c},easeInSine:function(a,b,c,d,e){return-d*Math.cos(b/e*(Math.PI/2))+d+c},easeOutSine:function(a,b,c,d,e){return d*Math.sin(b/e*(Math.PI/2))+c},easeInOutSine:function(a,b,c,d,e){return-d/2*(Math.cos(Math.PI*b/e)-1)+c},easeInExpo:function(a,b,c,d,e){return b==0?c:d*Math.pow(2,10*(b/e-1))+c},easeOutExpo:function(a,b,c,d,e){return b==e?c+d:d*(-Math.pow(2,-10*b/e)+1)+c},easeInOutExpo:function(a,b,c,d,e){return b==0?c:b==e?c+d:(b/=e/2)<1?d/2*Math.pow(2,10*(b-1))+c:d/2*(-Math.pow(2,-10*--b)+2)+c},easeInCirc:function(a,b,c,d,e){return-d*(Math.sqrt(1-(b/=e)*b)-1)+c},easeOutCirc:function(a,b,c,d,e){return d*Math.sqrt(1-(b=b/e-1)*b)+c},easeInOutCirc:function(a,b,c,d,e){return(b/=e/2)<1?-d/2*(Math.sqrt(1-b*b)-1)+c:d/2*(Math.sqrt(1-(b-=2)*b)+1)+c},easeInElastic:function(a,b,c,d,e){var f=1.70158,g=0,h=d;if(b==0)return c;if((b/=e)==1)return c+d;g||(g=e*.3);if(h<Math.abs(d)){h=d;var f=g/4}else var f=g/(2*Math.PI)*Math.asin(d/h);return-(h*Math.pow(2,10*(b-=1))*Math.sin((b*e-f)*2*Math.PI/g))+c},easeOutElastic:function(a,b,c,d,e){var f=1.70158,g=0,h=d;if(b==0)return c;if((b/=e)==1)return c+d;g||(g=e*.3);if(h<Math.abs(d)){h=d;var f=g/4}else var f=g/(2*Math.PI)*Math.asin(d/h);return h*Math.pow(2,-10*b)*Math.sin((b*e-f)*2*Math.PI/g)+d+c},easeInOutElastic:function(a,b,c,d,e){var f=1.70158,g=0,h=d;if(b==0)return c;if((b/=e/2)==2)return c+d;g||(g=e*.3*1.5);if(h<Math.abs(d)){h=d;var f=g/4}else var f=g/(2*Math.PI)*Math.asin(d/h);return b<1?-0.5*h*Math.pow(2,10*(b-=1))*Math.sin((b*e-f)*2*Math.PI/g)+c:h*Math.pow(2,-10*(b-=1))*Math.sin((b*e-f)*2*Math.PI/g)*.5+d+c},easeInBack:function(a,c,d,e,f,g){return g==b&&(g=1.70158),e*(c/=f)*c*((g+1)*c-g)+d},easeOutBack:function(a,c,d,e,f,g){return g==b&&(g=1.70158),e*((c=c/f-1)*c*((g+1)*c+g)+1)+d},easeInOutBack:function(a,c,d,e,f,g){return g==b&&(g=1.70158),(c/=f/2)<1?e/2*c*c*(((g*=1.525)+1)*c-g)+d:e/2*((c-=2)*c*(((g*=1.525)+1)*c+g)+2)+d},easeInBounce:function(b,c,d,e,f){return e-a.easing.easeOutBounce(b,f-c,0,e,f)+d},easeOutBounce:function(a,b,c,d,e){return(b/=e)<1/2.75?d*7.5625*b*b+c:b<2/2.75?d*(7.5625*(b-=1.5/2.75)*b+.75)+c:b<2.5/2.75?d*(7.5625*(b-=2.25/2.75)*b+.9375)+c:d*(7.5625*(b-=2.625/2.75)*b+.984375)+c},easeInOutBounce:function(b,c,d,e,f){return c<f/2?a.easing.easeInBounce(b,c*2,0,e,f)*.5+d:a.easing.easeOutBounce(b,c*2-f,0,e,f)*.5+e*.5+d}})}(jQuery);;/*! jQuery UI - v1.8.20 - 2012-04-30
 * https://github.com/jquery/jquery-ui
 * Includes: jquery.effects.slide.js
 * Copyright (c) 2012 AUTHORS.txt; Licensed MIT, GPL */
(function(a,b){a.effects.slide=function(b){return this.queue(function(){var c=a(this),d=["position","top","bottom","left","right"],e=a.effects.setMode(c,b.options.mode||"show"),f=b.options.direction||"left";a.effects.save(c,d),c.show(),a.effects.createWrapper(c).css({overflow:"hidden"});var g=f=="up"||f=="down"?"top":"left",h=f=="up"||f=="left"?"pos":"neg",i=b.options.distance||(g=="top"?c.outerHeight({margin:!0}):c.outerWidth({margin:!0}));e=="show"&&c.css(g,h=="pos"?isNaN(i)?"-"+i:-i:i);var j={};j[g]=(e=="show"?h=="pos"?"+=":"-=":h=="pos"?"-=":"+=")+i,c.animate(j,{queue:!1,duration:b.duration,easing:b.options.easing,complete:function(){e=="hide"&&c.hide(),a.effects.restore(c,d),a.effects.removeWrapper(c),b.callback&&b.callback.apply(this,arguments),c.dequeue()}})})}})(jQuery);;

/**
 Slimbox v2.03 - The ultimate lightweight Lightbox clone for jQuery
 (c) 2007-2009 Christophe Beyls <http://www.digitalia.be>
 MIT-style license.

 Modified by Shopware AG

 changelog
 - removes caption
 - new close button
 - new overlay image
 */
(function ($) {
    var win = $(window),
            options, images, activeImage = -1,
            activeThumb, prevThumb, startThumb, single, activeURL, prevImage, nextImage, compatibleOverlay, middle, centerWidth, centerHeight, ie6 = !window.XMLHttpRequest,
            video, operaFix = window.opera && (document.compatMode == "CSS1Compat") && ($.browser.version >= 9.3),
            documentElement = document.documentElement,
            preload = {},
            preloadPrev = new Image(),
            preloadNext = new Image(),
            overlay, center, image, thumbs, closer, sizer, prevLink, nextLink, bottomContainer, bottom, caption, number;
    $(function () {
        $("body").append($([overlay = $('<div id="lbOverlay" />').click(close)[0], center = $('<div id="lbCenter" />')[0], bottomContainer = $('<div id="lbBottomContainer" />')[0], closer = $('<div id="lbCloser" />').click(close)[0] ]).css("display", "none"));
        image = $('<div id="lbImage" />').appendTo(center).click(close).append(sizer = $('<div style="position: relative;" />').append([prevLink = $('<a id="lbPrevLink" href="#" />').click(previous)[0], nextLink = $('<a id="lbNextLink" href="#" />').click(next)[0]])[0])[0];
        thumbs = $('<div id="lbThumbs" />').appendTo(center);
        $('#lbImage').css('cursor', 'pointer');
    });
    $.slimbox = function (_images, startImage, thumbList, video, _options) {
        options = $.extend({
            loop: false,
            overlayOpacity: 0.3,
            overlayFadeDuration: 400,
            resizeDuration: 400,
            resizeEasing: "swing",
            initialWidth: 250,
            initialHeight: 250,
            imageFadeDuration: 600,
            captionAnimationDuration: 200,
            counterText: "Bild {x} von {y}",
            closeKeys: [27, 88, 67],
            previousKeys: [37, 80],
            nextKeys: [39, 78]
        }, _options);
        single = false;
        if (typeof _images[3] == 'undefined') {
            single = true
        }
        if (typeof _images == "string") {
            _images = [
                [_images, startImage]
            ];
            startImage = 0
        }
        if (!single) {
            $.each(thumbList, function (i, el) {
                var thumbimg = $('<img>', {
                    src: el,
                    index: i
                }).click(function () {
                            if (startThumb.hasClass('active')) startThumb.removeClass('active');
                            if (activeThumb) activeThumb.removeClass('active');
                            changeImage(i);
                            $(this).addClass('active');
                            activeThumb = $(this)
                        });
                if (i == startImage) {
                    thumbimg.addClass('active');
                    startThumb = thumbimg
                }
                var a = $('<a>', {
                    html: thumbimg
                }).appendTo(thumbs)
            })
        }
        middle = win.scrollTop() + ((operaFix ? documentElement.clientHeight : win.height()) / 2);
        centerWidth = options.initialWidth;
        centerHeight = options.initialHeight;
        $(center).css({
            top: Math.max(0, middle - (centerHeight / 2)),
            width: centerWidth,
            height: centerHeight,
            marginLeft: -centerWidth / 2
        }).show();
        /* compatibleOverlay = ie6 || (overlay.currentStyle && (overlay.currentStyle.position != "fixed"));
         if (compatibleOverlay) overlay.style.position = "absolute";*/
        $(overlay).css("opacity", options.overlayOpacity).fadeIn(options.overlayFadeDuration);
        position();
        setup(1);
        images = _images;
        options.loop = options.loop && (images.length > 1);
        return changeImage(startImage)
    };
    $.fn.slimbox = function (_options, linkMapper, linksFilter) {
        linkMapper = linkMapper ||
                function (el) {
                    return [el.href, el.title]
                };
        linksFilter = linksFilter ||
                function () {
                    return true
                };
        var thumbList = {};
        var links = this;
        return links.unbind("click").click(function () {
            var link = this,
                    startIndex = 0,
                    filteredLinks, i = 0,
                    length;
            filteredLinks = $.grep(links, function (el, i) {
                return linksFilter.call(link, el, i)
            });
            thumbList = {};
            video = {};
            $.each(filteredLinks, function (i, el) {
                if ($(el).children('img').length) {
                    thumbList[i] = $(el).children('img').attr('src')
                } else {
                    var _img = $(el).css('background-image').split('"');
                    thumbList[i] = _img[1]
                }
            });
            for (length = filteredLinks.length; i < length; ++i) {
                if (filteredLinks[i] == link) startIndex = i;
                filteredLinks[i] = linkMapper(filteredLinks[i], i)
            }
            return $.slimbox(filteredLinks, startIndex, thumbList, _options)
        })
    };

    function position() {
        var l = win.scrollLeft(),
                w = operaFix ? documentElement.clientWidth : win.width();
        $([center, bottomContainer, closer]).css("left", l + (w / 2));
        if (compatibleOverlay) $(overlay).css({
            left: l,
            top: win.scrollTop(),
            width: w,
            height: win.height()
        })
    }

    function setup(open) {
        /*$("object").add(ie6 ? "select" : "embed").each(function (index, el) {
         if (open) $.data(el, "slimbox", el.style.visibility);
         el.style.visibility = open ? "hidden" : $.data(el, "slimbox")
         }); */
        var fn = open ? "bind" : "unbind";
        win[fn]("scroll resize", position);
    }

    function previous() {
        return changeImage(prevImage)
    }

    function next() {
        return changeImage(nextImage)
    }

    function changeImage(imageIndex) {
        if (imageIndex >= 0) {
            $('#lbThumbs a img[index=' + imageIndex + ']').addClass('active');
            if (prevThumb) prevThumb.removeClass('active');
            prevThumb = $('#lbThumbs a img[index=' + imageIndex + ']');
            activeImage = imageIndex;
            activeURL = images[activeImage][0];
            prevImage = (activeImage || (options.loop ? images.length : 0)) - 1;
            nextImage = ((activeImage + 1) % images.length) || (options.loop ? 0 : -1);
            stop();
            center.className = "lbLoading";
            if ($.isEmptyObject(video)) {
                preload = new Image();
                preload.onload = animateBox;
                preload.src = activeURL
            } else {
                animateBox()
            }
        }
        return false
    }

    function animateBox() {
        center.className = "";
        if ($.isEmptyObject(video)) {
            $(image).css({
                backgroundImage: "url(" + activeURL + ")",
                visibility: "hidden",
                display: ""
            });
            $(sizer).width(preload.width);
            $([sizer, prevLink, nextLink]).height(preload.height)
        }
        $(caption).html(images[activeImage][1] || "");
        $(number).html((((images.length > 1) && options.counterText) || "").replace(/{x}/, activeImage + 1).replace(/{y}/, images.length));
        if (prevImage >= 0) preloadPrev.src = images[prevImage][0];
        if (nextImage >= 0) preloadNext.src = images[nextImage][0];
        centerWidth = image.offsetWidth;
        centerHeight = image.offsetHeight;
        if (!$.isEmptyObject(video)) {
            centerHeight = 500;
            centerWidth = 660;
            var div = $('<div>', {
                'id': 'player',
                'href': $(video[0][0]).attr('href'),
                'css': {
                    'height': centerHeight - 20,
                    'width': centerWidth - 20
                }
            }).appendTo($(image));
            flowplayer('player', 'video/flowplayer-3.1.5.swf')
        }
        var top = Math.max(0, middle - (centerHeight / 2));
        if (center.offsetHeight != centerHeight) {
            $(center).animate({
                'height': centerHeight,
                'top': top
            }, options.resizeDuration, options.resizeEasing)
        }
        if (center.offsetWidth != centerWidth) {
            $(center).animate({
                'width': centerWidth,
                'marginLeft': -(centerWidth / 2)
            }, options.resizeDuration, options.resizeEasing)
        }
        $(center).queue(function () {
            $(image).hide().css('visibility', 'visible').fadeIn(options.imageFadeDuration, animateCaption)
        });
        centerWidth = centerWidth / 2;
        $(closer).css({
            'top': top,
            'marginLeft': centerWidth - 11
        });


        //Hide Prev and Next picture link
        $.ie6fix.selectHide();
    }

    function animateCaption() {
        $(closer).show();
    }

    function stop() {
        preload.onload = null;
        preload.src = preloadPrev.src = preloadNext.src = activeURL;
        $([center, image, bottom]).stop(true);
        $([prevLink, nextLink, image, bottomContainer, closer]).hide()
        $.ie6fix.selectShow();
    }

    function close() {

        if (activeImage >= 0) {
            stop();
            $(thumbs).empty();
            $('#player').remove();
            activeImage = prevImage = nextImage = -1;
            $(center).hide();
            $(overlay).stop().fadeOut(options.overlayFadeDuration, setup)
        }
        $.ie6fix.selectShow();
        return false
    }
})(jQuery);

//////////////////////////////////////////////////////////////////////////////////
// Cloud Zoom V1.0.2
// (c) 2010 by R Cecco. <http://www.professorcloud.com>
// MIT License
//
// Please retain this copyright header in all versions of the software
//////////////////////////////////////////////////////////////////////////////////
(function ($) {

    $(document).ready(function () {
        $('.cloud-zoom, .cloud-zoom-gallery').CloudZoom();
    });

    function CloudZoom(jWin, opts) {
        var sImg = $('img', jWin);
        var img1;
        var img2;
        var zoomDiv = null;
        var $mouseTrap = null;
        var lens = null;
        var $tint = null;
        var softFocus = null;
        var $ie6Fix = null;
        var zoomImage;
        var controlTimer = 0;
        var cw, ch;
        var destU = 0;
        var destV = 0;
        var currV = 0;
        var currU = 0;
        var filesLoaded = 0;
        var mx, my;
        var ctx = this,
                zw;

        // Display an image loading message. This message gets deleted when the images have loaded and the zoom init function is called.
        // We add a small delay before the message is displayed to avoid the message flicking on then off again virtually immediately if the
        // images load really fast, e.g. from the cache.
        //var	ctx = this;
        setTimeout(function () {
            if ($mouseTrap === null) {
                var w = jWin.width();
                jWin.parent().append($.format('<div style="width:%0px;position:absolute;top:75%;left:%1px;text-align:center" class="cloud-zoom-loading" >Loading...</div>', w / 3, (w / 2) - (w / 6))).find(':last').css('opacity', 0.5);
            }
        }, 200);


        var ie6FixRemove = function () {

            if ($ie6Fix !== null) {
                $ie6Fix.remove();
                $ie6Fix = null;
            }
        };

        // Removes cursor, tint layer, blur layer etc.
        this.removeBits = function () {
            if (lens) {
                lens.remove();
                lens = null;
            }
            if ($tint) {
                $tint.remove();
                $tint = null;
            }
            if (softFocus) {
                softFocus.remove();
                softFocus = null;
            }
            ie6FixRemove();

            $('.cloud-zoom-loading', jWin.parent()).remove();
        };



        this.destroy = function () {
            jWin.data('zoom', null);

            if ($mouseTrap) {
                $mouseTrap.unbind();
                $mouseTrap.remove();
                $mouseTrap = null;
            }
            if (zoomDiv) {
                zoomDiv.remove();
                zoomDiv = null;
            }
            //ie6FixRemove();
            this.removeBits();
            // DON'T FORGET TO REMOVE JQUERY 'DATA' VALUES
        };


        // This is called when the zoom window has faded out so it can be removed.
        this.fadedOut = function () {

            if (zoomDiv) {
                zoomDiv.remove();
                zoomDiv = null;
            }
            this.removeBits();
            ie6FixRemove();
        };

        this.controlLoop = function () {
            if (lens) {
                var x = (mx - sImg.offset().left - (cw * 0.5)) >> 0;
                var y = (my - sImg.offset().top - (ch * 0.5)) >> 0;

                if (x < 0) {
                    x = 0;
                } else if (x > (sImg.outerWidth() - cw)) {
                    x = (sImg.outerWidth() - cw);
                }
                if (y < 0) {
                    y = 0;
                } else if (y > (sImg.outerHeight() - ch)) {
                    y = (sImg.outerHeight() - ch);
                }

                lens.css({
                    left: x,
                    top: y
                });
                lens.css('background-position', (-x) + 'px ' + (-y) + 'px');

                destU = (((x) / sImg.outerWidth()) * zoomImage.width) >> 0;
                destV = (((y) / sImg.outerHeight()) * zoomImage.height) >> 0;
                currU += (destU - currU) / opts.smoothMove;
                currV += (destV - currV) / opts.smoothMove;

                zoomDiv.css('background-position', (-(currU >> 0) + 'px ') + (-(currV >> 0) + 'px'));
            }
            controlTimer = setTimeout(function () {
                ctx.controlLoop();
            }, 30);
        };

        this.init2 = function (img, id) {

            var wrap = $('#wrap');
            var wrapimg = $('#zoom1 img');

            $('#wrap').css('width', wrapimg.innerWidth());

            filesLoaded++;
            if (id === 1) {
                zoomImage = img;
            }

            //this.images[id] = img;
            if (filesLoaded === 2) {

                //wrap.css('width', wrapimg.outerWidth());
                this.init();
            }
        };

        /* Init function start.  */
        this.init = function () {
            // Remove loading message (if present);
            $('.cloud-zoom-loading', jWin.parent()).remove();


            /* Add a box (mouseTrap) over the small image to trap mouse events.
             It has priority over zoom window to avoid issues with inner zoom.
             We need the dummy background image as IE does not trap mouse events on
             transparent parts of a div.
             */
            $mouseTrap = jWin.parent().append($.format("<div class='mousetrap' style='z-index:999;position:absolute;width:100%;height:%0px;left:%1px;top:%2px;\'></div>", sImg.outerHeight(), 0, 0)).find(':last');

            if ($.browser.msie && parseInt($.browser.version) < 10) {
                $mouseTrap.css('background', 'url(".")');
            }

            $mouseTrap.bind('click', this, function (event) {
                $(this).prev().addClass('startimage');
                var relEl = $("a[rel^='" + $(this).prev().attr('rel') + "']");
                var images = [];
                var thumblist = {};
                var video = {};
                var startImage = 0;
                $.each(relEl, function (i, el) {
                    if ($(el).hasClass('startimage')) {
                        startImage = i
                    }
                    images[i] = [$(el).attr('href')];
                    if ($(el).children('img').attr('src')) {
                        thumblist[i] = $(el).children('img').attr('src')
                    } else {
                        thumblist[i] = $(el).attr('href')
                    }
                });
                $.slimbox(images, startImage, thumblist, video)
            });


            //////////////////////////////////////////////////////////////////////
            /* Do as little as possible in mousemove event to prevent slowdown. */
            $mouseTrap.bind('mousemove', this, function (event) {
                // Just update the mouse position
                mx = event.pageX;
                my = event.pageY;
            });
            //////////////////////////////////////////////////////////////////////
            $mouseTrap.bind('mouseleave', this, function (event) {

                clearTimeout(controlTimer);
                //event.data.removeBits();
                if (lens) {
                    lens.fadeOut(299);
                }
                if ($tint) {
                    $tint.fadeOut(299);
                }
                if (softFocus) {
                    softFocus.fadeOut(299);
                }

                zoomDiv.fadeOut(300, function () {
                    ctx.fadedOut();
                });
                $.ie6fix.selectShow();
                return false;
            });
            //////////////////////////////////////////////////////////////////////
            $mouseTrap.bind('mouseenter', this, function (event) {

                $.ie6fix.selectHide();

                mx = event.pageX;
                my = event.pageY;
                zw = event.data;
                if (zoomDiv) {
                    zoomDiv.stop(true, false);
                    zoomDiv.remove();
                }

                var xPos = opts.adjustX,
                        yPos = opts.adjustY;

                var siw = sImg.outerWidth();
                var sih = sImg.outerHeight();

                var w = opts.zoomWidth;
                var h = opts.zoomHeight;
                if (opts.zoomWidth == 'auto') {
                    w = siw;
                }
                if (opts.zoomHeight == 'auto') {
                    h = sih;
                }
                //$('#info').text( xPos + ' ' + yPos + ' ' + siw + ' ' + sih );
                var appendTo = jWin.parent(); // attach to the wrapper
                switch (opts.position) {
                    case 'top':
                        yPos -= h; // + opts.adjustY;
                        break;
                    case 'right':
                        xPos += siw; // + opts.adjustX;
                        break;
                    case 'bottom':
                        yPos += sih; // + opts.adjustY;
                        break;
                    case 'left':
                        xPos -= w; // + opts.adjustX;
                        break;
                    case 'inside':
                        w = siw;
                        h = sih;
                        break;
                    // All other values, try and find an id in the dom to attach to.
                    default:
                        appendTo = $('#' + opts.position);
                        // If dom element doesn't exit, just use 'right' position as default.
                        if (!appendTo.length) {
                            appendTo = jWin;
                            xPos += siw; //+ opts.adjustX;
                            yPos += sih; // + opts.adjustY;
                        } else {
                            w = appendTo.innerWidth();
                            h = appendTo.innerHeight();
                        }
                }
                var pos = appendTo.offset();
                zoomDiv = $(document.body).append($.format('<div id="cloud-zoom-big" class="cloud-zoom-big" style="display:none;position:absolute;left:%0px;top:%1px;width:%2px;height:%3px;background:#FFF url(\'%4\') no-repeat;z-index:99;"></div>', pos.left + sImg.width() + 15, pos.top - 4, w, h, zoomImage.src)).find(':last');

                // Add the title from title tag.
                if (sImg.attr('title') && opts.showTitle) {
                    zoomDiv.append($.format('<div class="cloud-zoom-title">%0</div>', sImg.attr('title'))).find(':last').css('opacity', opts.titleOpacity);
                }

                /* Work out size of cursor */
                cw = (sImg.outerWidth() / zoomImage.width) * zoomDiv.width();
                ch = (sImg.outerHeight() / zoomImage.height) * zoomDiv.height();

                // if the zoom is larger than the actual picture
                if (cw > sImg.outerWidth()) {
                    cw = sImg.outerWidth();
                    zoomDiv.width(zoomImage.width);
                }

                zoomDiv.fadeIn(500);

                if (lens) {
                    lens.remove();
                    lens = null;
                }

                // Attach mouse, initially invisible to prevent first frame glitch
                lens = jWin.append($.format("<div class='cloud-zoom-lens' style='display:none;z-index:98;position:absolute;width:%0px;height:%1px;'></div>", cw, ch)).find(':last').fadeTo(200, 0.4);


                $mouseTrap.css('cursor', lens.css('cursor'));

                var noTrans = false;

                // Init tint layer if needed. (Not relevant if using inside mode)
                if (opts.tint) {
                    lens.css('background', 'url("' + sImg.attr('src') + '")');
                    $tint = jWin.append($.format('<div style="display:none;position:absolute; left:0px; top:0px; width:%0px; height:%1px; background-color:%2;" />', sImg.outerWidth(), sImg.outerHeight(), opts.tint)).find(':last');
                    $tint.css('opacity', opts.tintOpacity);
                    noTrans = true;
                    $tint.fadeIn(500);

                }
                if (opts.softFocus) {
                    lens.css('background', 'url("' + sImg.attr('src') + '")');
                    softFocus = jWin.append($.format('<div style="position:absolute;display:none;top:2px; left:2px; width:%0px; height:%1px;" />', sImg.outerWidth() - 2, sImg.outerHeight() - 2, opts.tint)).find(':last');
                    softFocus.css('background', 'url("' + sImg.attr('src') + '")');
                    softFocus.css('opacity', 0.5);
                    noTrans = true;
                    softFocus.fadeIn(500);
                }

                /*if (!noTrans) {
                 lens.css('opacity', opts.lensOpacity); // opacity for all modern browsers
                 if ($.browser.msie && parseInt($.browser.version) > 6) {
                 lens.css('-ms-filter', '"progid:DXImageTransform.Microsoft.Alpha(Opacity=50)"'); // opacity for ie 8
                 } else {
                 lens.css('filter', 'alpha(opacity=50)'); // opacity for ie 6-7
                 }
                 }*/
                if (opts.position !== 'inside') {
                    lens.fadeIn(200);
                }

                // Start processing.
                zw.controlLoop();

                return; // Don't return false here otherwise opera will not detect change of the mouse pointer type.
            });
        };


        img1 = new Image();
        $(img1).load(function () {
            ctx.init2(this, 0);

        });
        img1.src = sImg.attr('src');

        img2 = new Image();
        $(img2).load(function () {
            ctx.init2(this, 1);
        });
        img2.src = jWin.attr('href');
    }

    $.fn.CloudZoom = function (options) {
        try {
            document.execCommand("BackgroundImageCache", false, true)
        } catch (e) {}
        this.each(function () {
            var relOpts, opts;
            if ($(this).is('.cloud-zoom')) {

                var img = $(this).find('img');

                $(this).css({
                    'position': 'relative',
                    'display': 'block',
                    'margin': '0 auto',
                    'text-align': 'center'
                });
                $('img', $(this)).css({
                    'display': 'block'
                });

                var img = $(this).find('img');

                if ($(this).parent().attr('id') != 'wrap') {
                    $(this).wrap('<div id="wrap" style="top:0px;z-index:9;position:relative;width:' + img.innerWidth() + 'px;margin:0 auto"></div>')
                }
                opts = $.extend({}, $.fn.CloudZoom.defaults, options);
                opts = $.extend({}, opts, relOpts);
                $(this).data('zoom', new CloudZoom($(this), opts));
            } else if ($(this).is('.cloud-zoom-gallery')) {
                relOpts = {
                    useZoom: 'zoom1',
                    smallImage: $(this).attr('src')
                };
                if (!$(this).parent().attr('id')) {
                    relOpts.smallImage = $(this).attr('rev');
                } else {
                    relOpts.smallImage = $(this).attr('src');
                }
                opts = $.extend({}, relOpts, options);
                $(this).data('relOpts', opts);
                $(this).bind('click', $(this), function (event) {
                    event.preventDefault();
                    var data = event.data.data('relOpts');
                    $('#' + data.useZoom).data('zoom').destroy();
                    $('#' + data.useZoom).attr('href', event.data.attr('href'));
                    $('#' + data.useZoom + ' img').attr('src', relOpts.smallImage);
                    $('#' + event.data.data('relOpts').useZoom).CloudZoom();

                    // change title
                    $('#zoom1 img').attr('title', $(this).attr('title'));

                    //fading picture
                    if ($.browser.msie && parseInt($.browser.version) > 8) {
                        $('#wrap').fadeTo(0, 0.01).delay(200).fadeTo(200, 1);
                    }
                    return false;
                });
            }
        });
        return this
    };
    $.fn.CloudZoom.defaults = {
        zoomWidth: 487,
        zoomHeight: 260,
        position: 'right',
        tint: false,
        tintOpacity: 0.5,
        lensOpacity: 0.5,
        softFocus: false,
        smoothMove: 3,
        showTitle: true,
        titleOpacity: 0.5,
        adjustX: 20,
        adjustY: -5
    }
})(jQuery);

/*! jQuery UI - v1.8.21 - 2012-06-05
 * https://github.com/jquery/jquery-ui
 * Includes: jquery.ui.datepicker.js
 * Copyright (c) 2012 AUTHORS.txt; Licensed MIT, GPL
 *
 */
(function ($) {
    function Datepicker() {
        this.debug = !1, this._curInst = null, this._keyEvent = !1, this._disabledInputs = [], this._datepickerShowing = !1, this._inDialog = !1, this._mainDivId = "ui-datepicker-div", this._inlineClass = "ui-datepicker-inline", this._appendClass = "ui-datepicker-append", this._triggerClass = "ui-datepicker-trigger", this._dialogClass = "ui-datepicker-dialog", this._disableClass = "ui-datepicker-disabled", this._unselectableClass = "ui-datepicker-unselectable", this._currentClass = "ui-datepicker-current-day", this._dayOverClass = "ui-datepicker-days-cell-over", this.regional = [], this.regional[""] = {
            closeText:"Done",
            prevText:"Prev",
            nextText:"Next",
            currentText:"Today",
            monthNames:["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
            monthNamesShort:["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
            dayNames:["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
            dayNamesShort:["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
            dayNamesMin:["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
            weekHeader:"Wk",
            dateFormat:"mm/dd/yy",
            firstDay:0,
            isRTL:!1,
            showMonthAfterYear:!1,
            yearSuffix:""
        }, this._defaults = {
            showOn:"focus",
            showAnim:"fadeIn",
            showOptions:{},
            defaultDate:null,
            appendText:"",
            buttonText:"...",
            buttonImage:"",
            buttonImageOnly:!1,
            hideIfNoPrevNext:!1,
            navigationAsDateFormat:!1,
            gotoCurrent:!1,
            changeMonth:!1,
            changeYear:!1,
            yearRange:"c-10:c+10",
            showOtherMonths:!1,
            selectOtherMonths:!1,
            showWeek:!1,
            calculateWeek:this.iso8601Week,
            shortYearCutoff:"+10",
            minDate:null,
            maxDate:null,
            duration:"fast",
            beforeShowDay:null,
            beforeShow:null,
            onSelect:null,
            onChangeMonthYear:null,
            onClose:null,
            numberOfMonths:1,
            showCurrentAtPos:0,
            stepMonths:1,
            stepBigMonths:12,
            altField:"",
            altFormat:"",
            constrainInput:!0,
            showButtonPanel:!1,
            autoSize:!1,
            disabled:!1
        }, $.extend(this._defaults, this.regional[""]), this.dpDiv = bindHover($('<div id="' + this._mainDivId + '" class="ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all"></div>'))
    }

    function bindHover(a) {
        var b = "button, .ui-datepicker-prev, .ui-datepicker-next, .ui-datepicker-calendar td a";
        return a.bind("mouseout",function (a) {
            var c = $(a.target).closest(b);
            if (!c.length) return;
            c.removeClass("ui-state-hover ui-datepicker-prev-hover ui-datepicker-next-hover")
        }).bind("mouseover", function (c) {
                    var d = $(c.target).closest(b);
                    if ($.datepicker._isDisabledDatepicker(instActive.inline ? a.parent()[0] : instActive.input[0]) || !d.length) return;
                    d.parents(".ui-datepicker-calendar").find("a").removeClass("ui-state-hover"), d.addClass("ui-state-hover"), d.hasClass("ui-datepicker-prev") && d.addClass("ui-datepicker-prev-hover"), d.hasClass("ui-datepicker-next") && d.addClass("ui-datepicker-next-hover")
                })
    }

    function extendRemove(a, b) {
        $.extend(a, b);
        for (var c in b) if (b[c] == null || b[c] == undefined) a[c] = b[c];
        return a
    }

    function isArray(a) {
        return a && ($.browser.safari && typeof a == "object" && a.length || a.constructor && a.constructor.toString().match(/\Array\(\)/))
    }

    $.extend($.ui, {
        datepicker:{
            version:"1.8.21"
        }
    });
    var PROP_NAME = "datepicker",
            dpuuid = (new Date).getTime(),
            instActive;
    $.extend(Datepicker.prototype, {
        markerClassName:"hasDatepicker",
        maxRows:4,
        log:function () {
            this.debug && console.log.apply("", arguments)
        },
        _widgetDatepicker:function () {
            return this.dpDiv
        },
        setDefaults:function (a) {
            return extendRemove(this._defaults, a || {}), this
        },
        _attachDatepicker:function (target, settings) {
            var inlineSettings = null;
            for (var attrName in this._defaults) {
                var attrValue = target.getAttribute("date:" + attrName);
                if (attrValue) {
                    inlineSettings = inlineSettings || {};
                    try {
                        inlineSettings[attrName] = eval(attrValue)
                    } catch (err) {
                        inlineSettings[attrName] = attrValue
                    }
                }
            }
            var nodeName = target.nodeName.toLowerCase(),
                    inline = nodeName == "div" || nodeName == "span";
            target.id || (this.uuid += 1, target.id = "dp" + this.uuid);
            var inst = this._newInst($(target), inline);
            inst.settings = $.extend({}, settings || {}, inlineSettings || {}), nodeName == "input" ? this._connectDatepicker(target, inst) : inline && this._inlineDatepicker(target, inst)
        },
        _newInst:function (a, b) {
            var c = a[0].id.replace(/([^A-Za-z0-9_-])/g, "\\\\$1");
            return {
                id:c,
                input:a,
                selectedDay:0,
                selectedMonth:0,
                selectedYear:0,
                drawMonth:0,
                drawYear:0,
                inline:b,
                dpDiv:b ? bindHover($('<div class="' + this._inlineClass + ' ui-datepicker ui-widget ui-widget-content ui-helper-clearfix ui-corner-all"></div>')) : this.dpDiv
            }
        },
        _connectDatepicker:function (a, b) {
            var c = $(a);
            b.append = $([]), b.trigger = $([]);
            if (c.hasClass(this.markerClassName)) return;
            this._attachments(c, b), c.addClass(this.markerClassName).keydown(this._doKeyDown).keypress(this._doKeyPress).keyup(this._doKeyUp).bind("setData.datepicker",function (a, c, d) {
                b.settings[c] = d
            }).bind("getData.datepicker", function (a, c) {
                        return this._get(b, c)
                    }), this._autoSize(b), $.data(a, PROP_NAME, b), b.settings.disabled && this._disableDatepicker(a)
        },
        _attachments:function (a, b) {
            var c = this._get(b, "appendText"),
                    d = this._get(b, "isRTL");
            b.append && b.append.remove(), c && (b.append = $('<span class="' + this._appendClass + '">' + c + "</span>"), a[d ? "before" : "after"](b.append)), a.unbind("focus", this._showDatepicker), b.trigger && b.trigger.remove();
            var e = this._get(b, "showOn");
            (e == "focus" || e == "both") && a.focus(this._showDatepicker);
            if (e == "button" || e == "both") {
                var f = this._get(b, "buttonText"),
                        g = this._get(b, "buttonImage");
                b.trigger = $(this._get(b, "buttonImageOnly") ? $("<img/>").addClass(this._triggerClass).attr({
                    src:g,
                    alt:f,
                    title:f
                }) : $('<button type="button"></button>').addClass(this._triggerClass).html(g == "" ? f : $("<img/>").attr({
                    src:g,
                    alt:f,
                    title:f
                }))), a[d ? "before" : "after"](b.trigger), b.trigger.click(function () {
                    return $.datepicker._datepickerShowing && $.datepicker._lastInput == a[0] ? $.datepicker._hideDatepicker() : $.datepicker._datepickerShowing && $.datepicker._lastInput != a[0] ? ($.datepicker._hideDatepicker(), $.datepicker._showDatepicker(a[0])) : $.datepicker._showDatepicker(a[0]), !1
                })
            }
        },
        _autoSize:function (a) {
            if (this._get(a, "autoSize") && !a.inline) {
                var b = new Date(2009, 11, 20),
                        c = this._get(a, "dateFormat");
                if (c.match(/[DM]/)) {
                    var d = function (a) {
                        var b = 0,
                                c = 0;
                        for (var d = 0; d < a.length; d++) a[d].length > b && (b = a[d].length, c = d);
                        return c
                    };
                    b.setMonth(d(this._get(a, c.match(/MM/) ? "monthNames" : "monthNamesShort"))), b.setDate(d(this._get(a, c.match(/DD/) ? "dayNames" : "dayNamesShort")) + 20 - b.getDay())
                }
                a.input.attr("size", this._formatDate(a, b).length)
            }
        },
        _inlineDatepicker:function (a, b) {
            var c = $(a);
            if (c.hasClass(this.markerClassName)) return;
            c.addClass(this.markerClassName).append(b.dpDiv).bind("setData.datepicker",function (a, c, d) {
                b.settings[c] = d
            }).bind("getData.datepicker", function (a, c) {
                        return this._get(b, c)
                    }), $.data(a, PROP_NAME, b), this._setDate(b, this._getDefaultDate(b), !0), this._updateDatepicker(b), this._updateAlternate(b), b.settings.disabled && this._disableDatepicker(a), b.dpDiv.css("display", "block")
        },
        _dialogDatepicker:function (a, b, c, d, e) {
            var f = this._dialogInst;
            if (!f) {
                this.uuid += 1;
                var g = "dp" + this.uuid;
                this._dialogInput = $('<input type="text" id="' + g + '" style="position: absolute; top: -100px; width: 0px; z-index: -10;"/>'), this._dialogInput.keydown(this._doKeyDown), $("body").append(this._dialogInput), f = this._dialogInst = this._newInst(this._dialogInput, !1), f.settings = {}, $.data(this._dialogInput[0], PROP_NAME, f)
            }
            extendRemove(f.settings, d || {}), b = b && b.constructor == Date ? this._formatDate(f, b) : b, this._dialogInput.val(b), this._pos = e ? e.length ? e : [e.pageX, e.pageY] : null;
            if (!this._pos) {
                var h = document.documentElement.clientWidth,
                        i = document.documentElement.clientHeight,
                        j = document.documentElement.scrollLeft || document.body.scrollLeft,
                        k = document.documentElement.scrollTop || document.body.scrollTop;
                this._pos = [h / 2 - 100 + j, i / 2 - 150 + k]
            }
            return this._dialogInput.css("left", this._pos[0] + 20 + "px").css("top", this._pos[1] + "px"), f.settings.onSelect = c, this._inDialog = !0, this.dpDiv.addClass(this._dialogClass), this._showDatepicker(this._dialogInput[0]), $.blockUI && $.blockUI(this.dpDiv), $.data(this._dialogInput[0], PROP_NAME, f), this
        },
        _destroyDatepicker:function (a) {
            var b = $(a),
                    c = $.data(a, PROP_NAME);
            if (!b.hasClass(this.markerClassName)) return;
            var d = a.nodeName.toLowerCase();
            $.removeData(a, PROP_NAME), d == "input" ? (c.append.remove(), c.trigger.remove(), b.removeClass(this.markerClassName).unbind("focus", this._showDatepicker).unbind("keydown", this._doKeyDown).unbind("keypress", this._doKeyPress).unbind("keyup", this._doKeyUp)) : (d == "div" || d == "span") && b.removeClass(this.markerClassName).empty()
        },
        _enableDatepicker:function (a) {
            var b = $(a),
                    c = $.data(a, PROP_NAME);
            if (!b.hasClass(this.markerClassName)) return;
            var d = a.nodeName.toLowerCase();
            if (d == "input") a.disabled = !1, c.trigger.filter("button").each(function () {
                this.disabled = !1
            }).end().filter("img").css({
                        opacity:"1.0",
                        cursor:""
                    });
            else if (d == "div" || d == "span") {
                var e = b.children("." + this._inlineClass);
                e.children().removeClass("ui-state-disabled"), e.find("select.ui-datepicker-month, select.ui-datepicker-year").removeAttr("disabled")
            }
            this._disabledInputs = $.map(this._disabledInputs, function (b) {
                return b == a ? null : b
            })
        },
        _disableDatepicker:function (a) {
            var b = $(a),
                    c = $.data(a, PROP_NAME);
            if (!b.hasClass(this.markerClassName)) return;
            var d = a.nodeName.toLowerCase();
            if (d == "input") a.disabled = !0, c.trigger.filter("button").each(function () {
                this.disabled = !0
            }).end().filter("img").css({
                        opacity:"0.5",
                        cursor:"default"
                    });
            else if (d == "div" || d == "span") {
                var e = b.children("." + this._inlineClass);
                e.children().addClass("ui-state-disabled"), e.find("select.ui-datepicker-month, select.ui-datepicker-year").attr("disabled", "disabled")
            }
            this._disabledInputs = $.map(this._disabledInputs, function (b) {
                return b == a ? null : b
            }), this._disabledInputs[this._disabledInputs.length] = a
        },
        _isDisabledDatepicker:function (a) {
            if (!a) return !1;
            for (var b = 0; b < this._disabledInputs.length; b++) if (this._disabledInputs[b] == a) return !0;
            return !1
        },
        _getInst:function (a) {
            try {
                return $.data(a, PROP_NAME)
            } catch (b) {
                throw "Missing instance data for this datepicker"
            }
        },
        _optionDatepicker:function (a, b, c) {
            var d = this._getInst(a);
            if (arguments.length == 2 && typeof b == "string") return b == "defaults" ? $.extend({}, $.datepicker._defaults) : d ? b == "all" ? $.extend({}, d.settings) : this._get(d, b) : null;
            var e = b || {};
            typeof b == "string" && (e = {}, e[b] = c);
            if (d) {
                this._curInst == d && this._hideDatepicker();
                var f = this._getDateDatepicker(a, !0),
                        g = this._getMinMaxDate(d, "min"),
                        h = this._getMinMaxDate(d, "max");
                extendRemove(d.settings, e), g !== null && e.dateFormat !== undefined && e.minDate === undefined && (d.settings.minDate = this._formatDate(d, g)), h !== null && e.dateFormat !== undefined && e.maxDate === undefined && (d.settings.maxDate = this._formatDate(d, h)), this._attachments($(a), d), this._autoSize(d), this._setDate(d, f), this._updateAlternate(d), this._updateDatepicker(d)
            }
        },
        _changeDatepicker:function (a, b, c) {
            this._optionDatepicker(a, b, c)
        },
        _refreshDatepicker:function (a) {
            var b = this._getInst(a);
            b && this._updateDatepicker(b)
        },
        _setDateDatepicker:function (a, b) {
            var c = this._getInst(a);
            c && (this._setDate(c, b), this._updateDatepicker(c), this._updateAlternate(c))
        },
        _getDateDatepicker:function (a, b) {
            var c = this._getInst(a);
            return c && !c.inline && this._setDateFromField(c, b), c ? this._getDate(c) : null
        },
        _doKeyDown:function (a) {
            var b = $.datepicker._getInst(a.target),
                    c = !0,
                    d = b.dpDiv.is(".ui-datepicker-rtl");
            b._keyEvent = !0;
            if ($.datepicker._datepickerShowing) switch (a.keyCode) {
                case 9:
                    $.datepicker._hideDatepicker(), c = !1;
                    break;
                case 13:
                    var e = $("td." + $.datepicker._dayOverClass + ":not(." + $.datepicker._currentClass + ")", b.dpDiv);
                    e[0] && $.datepicker._selectDay(a.target, b.selectedMonth, b.selectedYear, e[0]);
                    var f = $.datepicker._get(b, "onSelect");
                    if (f) {
                        var g = $.datepicker._formatDate(b);
                        f.apply(b.input ? b.input[0] : null, [g, b])
                    } else $.datepicker._hideDatepicker();
                    return !1;
                case 27:
                    $.datepicker._hideDatepicker();
                    break;
                case 33:
                    $.datepicker._adjustDate(a.target, a.ctrlKey ? -$.datepicker._get(b, "stepBigMonths") : -$.datepicker._get(b, "stepMonths"), "M");
                    break;
                case 34:
                    $.datepicker._adjustDate(a.target, a.ctrlKey ? +$.datepicker._get(b, "stepBigMonths") : +$.datepicker._get(b, "stepMonths"), "M");
                    break;
                case 35:
                    (a.ctrlKey || a.metaKey) && $.datepicker._clearDate(a.target), c = a.ctrlKey || a.metaKey;
                    break;
                case 36:
                    (a.ctrlKey || a.metaKey) && $.datepicker._gotoToday(a.target), c = a.ctrlKey || a.metaKey;
                    break;
                case 37:
                    (a.ctrlKey || a.metaKey) && $.datepicker._adjustDate(a.target, d ? 1 : -1, "D"), c = a.ctrlKey || a.metaKey, a.originalEvent.altKey && $.datepicker._adjustDate(a.target, a.ctrlKey ? -$.datepicker._get(b, "stepBigMonths") : -$.datepicker._get(b, "stepMonths"), "M");
                    break;
                case 38:
                    (a.ctrlKey || a.metaKey) && $.datepicker._adjustDate(a.target, -7, "D"), c = a.ctrlKey || a.metaKey;
                    break;
                case 39:
                    (a.ctrlKey || a.metaKey) && $.datepicker._adjustDate(a.target, d ? -1 : 1, "D"), c = a.ctrlKey || a.metaKey, a.originalEvent.altKey && $.datepicker._adjustDate(a.target, a.ctrlKey ? +$.datepicker._get(b, "stepBigMonths") : +$.datepicker._get(b, "stepMonths"), "M");
                    break;
                case 40:
                    (a.ctrlKey || a.metaKey) && $.datepicker._adjustDate(a.target, 7, "D"), c = a.ctrlKey || a.metaKey;
                    break;
                default:
                    c = !1
            } else a.keyCode == 36 && a.ctrlKey ? $.datepicker._showDatepicker(this) : c = !1;
            c && (a.preventDefault(), a.stopPropagation())
        },
        _doKeyPress:function (a) {
            var b = $.datepicker._getInst(a.target);
            if ($.datepicker._get(b, "constrainInput")) {
                var c = $.datepicker._possibleChars($.datepicker._get(b, "dateFormat")),
                        d = String.fromCharCode(a.charCode == undefined ? a.keyCode : a.charCode);
                return a.ctrlKey || a.metaKey || d < " " || !c || c.indexOf(d) > -1
            }
        },
        _doKeyUp:function (a) {
            var b = $.datepicker._getInst(a.target);
            if (b.input.val() != b.lastVal) try {
                var c = $.datepicker.parseDate($.datepicker._get(b, "dateFormat"), b.input ? b.input.val() : null, $.datepicker._getFormatConfig(b));
                c && ($.datepicker._setDateFromField(b), $.datepicker._updateAlternate(b), $.datepicker._updateDatepicker(b))
            } catch (d) {
                $.datepicker.log(d)
            }
            return !0
        },
        _showDatepicker:function (a) {
            a = a.target || a, a.nodeName.toLowerCase() != "input" && (a = $("input", a.parentNode)[0]);
            if ($.datepicker._isDisabledDatepicker(a) || $.datepicker._lastInput == a) return;
            var b = $.datepicker._getInst(a);
            $.datepicker._curInst && $.datepicker._curInst != b && ($.datepicker._curInst.dpDiv.stop(!0, !0), b && $.datepicker._datepickerShowing && $.datepicker._hideDatepicker($.datepicker._curInst.input[0]));
            var c = $.datepicker._get(b, "beforeShow"),
                    d = c ? c.apply(a, [a, b]) : {};
            if (d === !1) return;
            extendRemove(b.settings, d), b.lastVal = null, $.datepicker._lastInput = a, $.datepicker._setDateFromField(b), $.datepicker._inDialog && (a.value = ""), $.datepicker._pos || ($.datepicker._pos = $.datepicker._findPos(a), $.datepicker._pos[1] += a.offsetHeight);
            var e = !1;
            $(a).parents().each(function () {
                return e |= $(this).css("position") == "fixed", !e
            }), e && $.browser.opera && ($.datepicker._pos[0] -= document.documentElement.scrollLeft, $.datepicker._pos[1] -= document.documentElement.scrollTop);
            var f = {
                left:$.datepicker._pos[0],
                top:$.datepicker._pos[1]
            };
            $.datepicker._pos = null, b.dpDiv.empty(), b.dpDiv.css({
                position:"absolute",
                display:"block",
                top:"-1000px"
            }), $.datepicker._updateDatepicker(b), f = $.datepicker._checkOffset(b, f, e), b.dpDiv.css({
                position:$.datepicker._inDialog && $.blockUI ? "static" : e ? "fixed" : "absolute",
                display:"none",
                left:f.left + "px",
                top:f.top + "px"
            });
            if (!b.inline) {
                var g = $.datepicker._get(b, "showAnim"),
                        h = $.datepicker._get(b, "duration"),
                        i = function () {
                            var a = b.dpDiv.find("iframe.ui-datepicker-cover");
                            if (!!a.length) {
                                var c = $.datepicker._getBorders(b.dpDiv);
                                a.css({
                                    left:-c[0],
                                    top:-c[1],
                                    width:b.dpDiv.outerWidth(),
                                    height:b.dpDiv.outerHeight()
                                })
                            }
                        };
                b.dpDiv.zIndex($(a).zIndex() + 1), $.datepicker._datepickerShowing = !0, $.effects && $.effects[g] ? b.dpDiv.show(g, $.datepicker._get(b, "showOptions"), h, i) : b.dpDiv[g || "show"](g ? h : null, i), (!g || !h) && i(), b.input.is(":visible") && !b.input.is(":disabled") && b.input.focus(), $.datepicker._curInst = b
            }
        },
        _updateDatepicker:function (a) {
            var b = this;
            b.maxRows = 4;
            var c = $.datepicker._getBorders(a.dpDiv);
            instActive = a, a.dpDiv.empty().append(this._generateHTML(a));
            var d = a.dpDiv.find("iframe.ui-datepicker-cover");
            !d.length || d.css({
                left:-c[0],
                top:-c[1],
                width:a.dpDiv.outerWidth(),
                height:a.dpDiv.outerHeight()
            }), a.dpDiv.find("." + this._dayOverClass + " a").mouseover();
            var e = this._getNumberOfMonths(a),
                    f = e[1],
                    g = 17;
            a.dpDiv.removeClass("ui-datepicker-multi-2 ui-datepicker-multi-3 ui-datepicker-multi-4").width(""), f > 1 && a.dpDiv.addClass("ui-datepicker-multi-" + f).css("width", g * f + "em"), a.dpDiv[(e[0] != 1 || e[1] != 1 ? "add" : "remove") + "Class"]("ui-datepicker-multi"), a.dpDiv[(this._get(a, "isRTL") ? "add" : "remove") + "Class"]("ui-datepicker-rtl"), a == $.datepicker._curInst && $.datepicker._datepickerShowing && a.input && a.input.is(":visible") && !a.input.is(":disabled") && a.input[0] != document.activeElement && a.input.focus();
            if (a.yearshtml) {
                var h = a.yearshtml;
                setTimeout(function () {
                    h === a.yearshtml && a.yearshtml && a.dpDiv.find("select.ui-datepicker-year:first").replaceWith(a.yearshtml), h = a.yearshtml = null
                }, 0)
            }
        },
        _getBorders:function (a) {
            var b = function (a) {
                return {
                    thin:1,
                    medium:2,
                    thick:3
                }[a] || a
            };
            return [parseFloat(b(a.css("border-left-width"))), parseFloat(b(a.css("border-top-width")))]
        },
        _checkOffset:function (a, b, c) {
            var d = a.dpDiv.outerWidth(),
                    e = a.dpDiv.outerHeight(),
                    f = a.input ? a.input.outerWidth() : 0,
                    g = a.input ? a.input.outerHeight() : 0,
                    h = document.documentElement.clientWidth + $(document).scrollLeft(),
                    i = document.documentElement.clientHeight + $(document).scrollTop();
            return b.left -= this._get(a, "isRTL") ? d - f : 0, b.left -= c && b.left == a.input.offset().left ? $(document).scrollLeft() : 0, b.top -= c && b.top == a.input.offset().top + g ? $(document).scrollTop() : 0, b.left -= Math.min(b.left, b.left + d > h && h > d ? Math.abs(b.left + d - h) : 0), b.top -= Math.min(b.top, b.top + e > i && i > e ? Math.abs(e + g) : 0), b
        },
        _findPos:function (a) {
            var b = this._getInst(a),
                    c = this._get(b, "isRTL");
            while (a && (a.type == "hidden" || a.nodeType != 1 || $.expr.filters.hidden(a))) a = a[c ? "previousSibling" : "nextSibling"];
            var d = $(a).offset();
            return [d.left, d.top]
        },
        _hideDatepicker:function (a) {
            var b = this._curInst;
            if (!b || a && b != $.data(a, PROP_NAME)) return;
            if (this._datepickerShowing) {
                var c = this._get(b, "showAnim"),
                        d = this._get(b, "duration"),
                        e = function () {
                            $.datepicker._tidyDialog(b)
                        };
                $.effects && $.effects[c] ? b.dpDiv.hide(c, $.datepicker._get(b, "showOptions"), d, e) : b.dpDiv[c == "slideDown" ? "slideUp" : c == "fadeIn" ? "fadeOut" : "hide"](c ? d : null, e), c || e(), this._datepickerShowing = !1;
                var f = this._get(b, "onClose");
                f && f.apply(b.input ? b.input[0] : null, [b.input ? b.input.val() : "", b]), this._lastInput = null, this._inDialog && (this._dialogInput.css({
                    position:"absolute",
                    left:"0",
                    top:"-100px"
                }), $.blockUI && ($.unblockUI(), $("body").append(this.dpDiv))), this._inDialog = !1
            }
        },
        _tidyDialog:function (a) {
            a.dpDiv.removeClass(this._dialogClass).unbind(".ui-datepicker-calendar")
        },
        _checkExternalClick:function (a) {
            if (!$.datepicker._curInst) return;
            var b = $(a.target),
                    c = $.datepicker._getInst(b[0]);
            (b[0].id != $.datepicker._mainDivId && b.parents("#" + $.datepicker._mainDivId).length == 0 && !b.hasClass($.datepicker.markerClassName) && !b.closest("." + $.datepicker._triggerClass).length && $.datepicker._datepickerShowing && (!$.datepicker._inDialog || !$.blockUI) || b.hasClass($.datepicker.markerClassName) && $.datepicker._curInst != c) && $.datepicker._hideDatepicker()
        },
        _adjustDate:function (a, b, c) {
            var d = $(a),
                    e = this._getInst(d[0]);
            if (this._isDisabledDatepicker(d[0])) return;
            this._adjustInstDate(e, b + (c == "M" ? this._get(e, "showCurrentAtPos") : 0), c), this._updateDatepicker(e)
        },
        _gotoToday:function (a) {
            var b = $(a),
                    c = this._getInst(b[0]);
            if (this._get(c, "gotoCurrent") && c.currentDay) c.selectedDay = c.currentDay, c.drawMonth = c.selectedMonth = c.currentMonth, c.drawYear = c.selectedYear = c.currentYear;
            else {
                var d = new Date;
                c.selectedDay = d.getDate(), c.drawMonth = c.selectedMonth = d.getMonth(), c.drawYear = c.selectedYear = d.getFullYear()
            }
            this._notifyChange(c), this._adjustDate(b)
        },
        _selectMonthYear:function (a, b, c) {
            var d = $(a),
                    e = this._getInst(d[0]);
            e["selected" + (c == "M" ? "Month" : "Year")] = e["draw" + (c == "M" ? "Month" : "Year")] = parseInt(b.options[b.selectedIndex].value, 10), this._notifyChange(e), this._adjustDate(d)
        },
        _selectDay:function (a, b, c, d) {
            var e = $(a);
            if ($(d).hasClass(this._unselectableClass) || this._isDisabledDatepicker(e[0])) return;
            var f = this._getInst(e[0]);
            f.selectedDay = f.currentDay = $("a", d).html(), f.selectedMonth = f.currentMonth = b, f.selectedYear = f.currentYear = c, this._selectDate(a, this._formatDate(f, f.currentDay, f.currentMonth, f.currentYear))
        },
        _clearDate:function (a) {
            var b = $(a),
                    c = this._getInst(b[0]);
            this._selectDate(b, "")
        },
        _selectDate:function (a, b) {
            var c = $(a),
                    d = this._getInst(c[0]);
            b = b != null ? b : this._formatDate(d), d.input && d.input.val(b), this._updateAlternate(d);
            var e = this._get(d, "onSelect");
            e ? e.apply(d.input ? d.input[0] : null, [b, d]) : d.input && d.input.trigger("change"), d.inline ? this._updateDatepicker(d) : (this._hideDatepicker(), this._lastInput = d.input[0], typeof d.input[0] != "object" && d.input.focus(), this._lastInput = null)
        },
        _updateAlternate:function (a) {
            var b = this._get(a, "altField");
            if (b) {
                var c = this._get(a, "altFormat") || this._get(a, "dateFormat"),
                        d = this._getDate(a),
                        e = this.formatDate(c, d, this._getFormatConfig(a));
                $(b).each(function () {
                    $(this).val(e)
                })
            }
        },
        noWeekends:function (a) {
            var b = a.getDay();
            return [b > 0 && b < 6, ""]
        },
        iso8601Week:function (a) {
            var b = new Date(a.getTime());
            b.setDate(b.getDate() + 4 - (b.getDay() || 7));
            var c = b.getTime();
            return b.setMonth(0), b.setDate(1), Math.floor(Math.round((c - b) / 864e5) / 7) + 1
        },
        parseDate:function (a, b, c) {
            if (a == null || b == null) throw "Invalid arguments";
            b = typeof b == "object" ? b.toString() : b + "";
            if (b == "") return null;
            var d = (c ? c.shortYearCutoff : null) || this._defaults.shortYearCutoff;
            d = typeof d != "string" ? d : (new Date).getFullYear() % 100 + parseInt(d, 10);
            var e = (c ? c.dayNamesShort : null) || this._defaults.dayNamesShort,
                    f = (c ? c.dayNames : null) || this._defaults.dayNames,
                    g = (c ? c.monthNamesShort : null) || this._defaults.monthNamesShort,
                    h = (c ? c.monthNames : null) || this._defaults.monthNames,
                    i = -1,
                    j = -1,
                    k = -1,
                    l = -1,
                    m = !1,
                    n = function (b) {
                        var c = s + 1 < a.length && a.charAt(s + 1) == b;
                        return c && s++, c
                    },
                    o = function (a) {
                        var c = n(a),
                                d = a == "@" ? 14 : a == "!" ? 20 : a == "y" && c ? 4 : a == "o" ? 3 : 2,
                                e = new RegExp("^\\d{1," + d + "}"),
                                f = b.substring(r).match(e);
                        if (!f) throw "Missing number at position " + r;
                        return r += f[0].length, parseInt(f[0], 10)
                    },
                    p = function (a, c, d) {
                        var e = $.map(n(a) ? d : c,function (a, b) {
                                    return [
                                        [b, a]
                                    ]
                                }).sort(function (a, b) {
                                            return -(a[1].length - b[1].length)
                                        }),
                                f = -1;
                        $.each(e, function (a, c) {
                            var d = c[1];
                            if (b.substr(r, d.length).toLowerCase() == d.toLowerCase()) return f = c[0], r += d.length, !1
                        });
                        if (f != -1) return f + 1;
                        throw "Unknown name at position " + r
                    },
                    q = function () {
                        if (b.charAt(r) != a.charAt(s)) throw "Unexpected literal at position " + r;
                        r++
                    },
                    r = 0;
            for (var s = 0; s < a.length; s++) if (m) a.charAt(s) == "'" && !n("'") ? m = !1 : q();
            else switch (a.charAt(s)) {
                    case "d":
                        k = o("d");
                        break;
                    case "D":
                        p("D", e, f);
                        break;
                    case "o":
                        l = o("o");
                        break;
                    case "m":
                        j = o("m");
                        break;
                    case "M":
                        j = p("M", g, h);
                        break;
                    case "y":
                        i = o("y");
                        break;
                    case "@":
                        var t = new Date(o("@"));
                        i = t.getFullYear(), j = t.getMonth() + 1, k = t.getDate();
                        break;
                    case "!":
                        var t = new Date((o("!") - this._ticksTo1970) / 1e4);
                        i = t.getFullYear(), j = t.getMonth() + 1, k = t.getDate();
                        break;
                    case "'":
                        n("'") ? q() : m = !0;
                        break;
                    default:
                        q()
                }
            if (r < b.length) throw "Extra/unparsed characters found in date: " + b.substring(r);
            i == -1 ? i = (new Date).getFullYear() : i < 100 && (i += (new Date).getFullYear() - (new Date).getFullYear() % 100 + (i <= d ? 0 : -100));
            if (l > -1) {
                j = 1, k = l;
                do {
                    var u = this._getDaysInMonth(i, j - 1);
                    if (k <= u) break;
                    j++, k -= u
                } while (!0)
            }
            var t = this._daylightSavingAdjust(new Date(i, j - 1, k));
            if (t.getFullYear() != i || t.getMonth() + 1 != j || t.getDate() != k) throw "Invalid date";
            return t
        },
        ATOM:"yy-mm-dd",
        COOKIE:"D, dd M yy",
        ISO_8601:"yy-mm-dd",
        RFC_822:"D, d M y",
        RFC_850:"DD, dd-M-y",
        RFC_1036:"D, d M y",
        RFC_1123:"D, d M yy",
        RFC_2822:"D, d M yy",
        RSS:"D, d M y",
        TICKS:"!",
        TIMESTAMP:"@",
        W3C:"yy-mm-dd",
        _ticksTo1970:(718685 + Math.floor(492.5) - Math.floor(19.7) + Math.floor(4.925)) * 24 * 60 * 60 * 1e7,
        formatDate:function (a, b, c) {
            if (!b) return "";
            var d = (c ? c.dayNamesShort : null) || this._defaults.dayNamesShort,
                    e = (c ? c.dayNames : null) || this._defaults.dayNames,
                    f = (c ? c.monthNamesShort : null) || this._defaults.monthNamesShort,
                    g = (c ? c.monthNames : null) || this._defaults.monthNames,
                    h = function (b) {
                        var c = m + 1 < a.length && a.charAt(m + 1) == b;
                        return c && m++, c
                    },
                    i = function (a, b, c) {
                        var d = "" + b;
                        if (h(a)) while (d.length < c) d = "0" + d;
                        return d
                    },
                    j = function (a, b, c, d) {
                        return h(a) ? d[b] : c[b]
                    },
                    k = "",
                    l = !1;
            if (b) for (var m = 0; m < a.length; m++) if (l) a.charAt(m) == "'" && !h("'") ? l = !1 : k += a.charAt(m);
            else switch (a.charAt(m)) {
                    case "d":
                        k += i("d", b.getDate(), 2);
                        break;
                    case "D":
                        k += j("D", b.getDay(), d, e);
                        break;
                    case "o":
                        k += i("o", Math.round(((new Date(b.getFullYear(), b.getMonth(), b.getDate())).getTime() - (new Date(b.getFullYear(), 0, 0)).getTime()) / 864e5), 3);
                        break;
                    case "m":
                        k += i("m", b.getMonth() + 1, 2);
                        break;
                    case "M":
                        k += j("M", b.getMonth(), f, g);
                        break;
                    case "y":
                        k += h("y") ? b.getFullYear() : (b.getYear() % 100 < 10 ? "0" : "") + b.getYear() % 100;
                        break;
                    case "@":
                        k += b.getTime();
                        break;
                    case "!":
                        k += b.getTime() * 1e4 + this._ticksTo1970;
                        break;
                    case "'":
                        h("'") ? k += "'" : l = !0;
                        break;
                    default:
                        k += a.charAt(m)
                }
            return k
        },
        _possibleChars:function (a) {
            var b = "",
                    c = !1,
                    d = function (b) {
                        var c = e + 1 < a.length && a.charAt(e + 1) == b;
                        return c && e++, c
                    };
            for (var e = 0; e < a.length; e++) if (c) a.charAt(e) == "'" && !d("'") ? c = !1 : b += a.charAt(e);
            else switch (a.charAt(e)) {
                    case "d":
                    case "m":
                    case "y":
                    case "@":
                        b += "0123456789";
                        break;
                    case "D":
                    case "M":
                        return null;
                    case "'":
                        d("'") ? b += "'" : c = !0;
                        break;
                    default:
                        b += a.charAt(e)
                }
            return b
        },
        _get:function (a, b) {
            return a.settings[b] !== undefined ? a.settings[b] : this._defaults[b]
        },
        _setDateFromField:function (a, b) {
            if (a.input.val() == a.lastVal) return;
            var c = this._get(a, "dateFormat"),
                    d = a.lastVal = a.input ? a.input.val() : null,
                    e, f;
            e = f = this._getDefaultDate(a);
            var g = this._getFormatConfig(a);
            try {
                e = this.parseDate(c, d, g) || f
            } catch (h) {
                this.log(h), d = b ? "" : d
            }
            a.selectedDay = e.getDate(), a.drawMonth = a.selectedMonth = e.getMonth(), a.drawYear = a.selectedYear = e.getFullYear(), a.currentDay = d ? e.getDate() : 0, a.currentMonth = d ? e.getMonth() : 0, a.currentYear = d ? e.getFullYear() : 0, this._adjustInstDate(a)
        },
        _getDefaultDate:function (a) {
            return this._restrictMinMax(a, this._determineDate(a, this._get(a, "defaultDate"), new Date))
        },
        _determineDate:function (a, b, c) {
            var d = function (a) {
                        var b = new Date;
                        return b.setDate(b.getDate() + a), b
                    },
                    e = function (b) {
                        try {
                            return $.datepicker.parseDate($.datepicker._get(a, "dateFormat"), b, $.datepicker._getFormatConfig(a))
                        } catch (c) {
                        }
                        var d = (b.toLowerCase().match(/^c/) ? $.datepicker._getDate(a) : null) || new Date,
                                e = d.getFullYear(),
                                f = d.getMonth(),
                                g = d.getDate(),
                                h = /([+-]?[0-9]+)\s*(d|D|w|W|m|M|y|Y)?/g,
                                i = h.exec(b);
                        while (i) {
                            switch (i[2] || "d") {
                                case "d":
                                case "D":
                                    g += parseInt(i[1], 10);
                                    break;
                                case "w":
                                case "W":
                                    g += parseInt(i[1], 10) * 7;
                                    break;
                                case "m":
                                case "M":
                                    f += parseInt(i[1], 10), g = Math.min(g, $.datepicker._getDaysInMonth(e, f));
                                    break;
                                case "y":
                                case "Y":
                                    e += parseInt(i[1], 10), g = Math.min(g, $.datepicker._getDaysInMonth(e, f))
                            }
                            i = h.exec(b)
                        }
                        return new Date(e, f, g)
                    },
                    f = b == null || b === "" ? c : typeof b == "string" ? e(b) : typeof b == "number" ? isNaN(b) ? c : d(b) : new Date(b.getTime());
            return f = f && f.toString() == "Invalid Date" ? c : f, f && (f.setHours(0), f.setMinutes(0), f.setSeconds(0), f.setMilliseconds(0)), this._daylightSavingAdjust(f)
        },
        _daylightSavingAdjust:function (a) {
            return a ? (a.setHours(a.getHours() > 12 ? a.getHours() + 2 : 0), a) : null
        },
        _setDate:function (a, b, c) {
            var d = !b,
                    e = a.selectedMonth,
                    f = a.selectedYear,
                    g = this._restrictMinMax(a, this._determineDate(a, b, new Date));
            a.selectedDay = a.currentDay = g.getDate(), a.drawMonth = a.selectedMonth = a.currentMonth = g.getMonth(), a.drawYear = a.selectedYear = a.currentYear = g.getFullYear(), (e != a.selectedMonth || f != a.selectedYear) && !c && this._notifyChange(a), this._adjustInstDate(a), a.input && a.input.val(d ? "" : this._formatDate(a))
        },
        _getDate:function (a) {
            var b = !a.currentYear || a.input && a.input.val() == "" ? null : this._daylightSavingAdjust(new Date(a.currentYear, a.currentMonth, a.currentDay));
            return b
        },
        _generateHTML:function (a) {
            var b = new Date;
            b = this._daylightSavingAdjust(new Date(b.getFullYear(), b.getMonth(), b.getDate()));
            var c = this._get(a, "isRTL"),
                    d = this._get(a, "showButtonPanel"),
                    e = this._get(a, "hideIfNoPrevNext"),
                    f = this._get(a, "navigationAsDateFormat"),
                    g = this._getNumberOfMonths(a),
                    h = this._get(a, "showCurrentAtPos"),
                    i = this._get(a, "stepMonths"),
                    j = g[0] != 1 || g[1] != 1,
                    k = this._daylightSavingAdjust(a.currentDay ? new Date(a.currentYear, a.currentMonth, a.currentDay) : new Date(9999, 9, 9)),
                    l = this._getMinMaxDate(a, "min"),
                    m = this._getMinMaxDate(a, "max"),
                    n = a.drawMonth - h,
                    o = a.drawYear;
            n < 0 && (n += 12, o--);
            if (m) {
                var p = this._daylightSavingAdjust(new Date(m.getFullYear(), m.getMonth() - g[0] * g[1] + 1, m.getDate()));
                p = l && p < l ? l : p;
                while (this._daylightSavingAdjust(new Date(o, n, 1)) > p) n--, n < 0 && (n = 11, o--)
            }
            a.drawMonth = n, a.drawYear = o;
            var q = this._get(a, "prevText");
            q = f ? this.formatDate(q, this._daylightSavingAdjust(new Date(o, n - i, 1)), this._getFormatConfig(a)) : q;
            var r = this._canAdjustMonth(a, -1, o, n) ? '<a class="ui-datepicker-prev ui-corner-all" onclick="DP_jQuery_' + dpuuid + ".datepicker._adjustDate('#" + a.id + "', -" + i + ", 'M');\"" + ' title="' + q + '"><span class="ui-icon ui-icon-circle-triangle-' + (c ? "e" : "w") + '">' + q + "</span></a>" : e ? "" : '<a class="ui-datepicker-prev ui-corner-all ui-state-disabled" title="' + q + '"><span class="ui-icon ui-icon-circle-triangle-' + (c ? "e" : "w") + '">' + q + "</span></a>",
                    s = this._get(a, "nextText");
            s = f ? this.formatDate(s, this._daylightSavingAdjust(new Date(o, n + i, 1)), this._getFormatConfig(a)) : s;
            var t = this._canAdjustMonth(a, 1, o, n) ? '<a class="ui-datepicker-next ui-corner-all" onclick="DP_jQuery_' + dpuuid + ".datepicker._adjustDate('#" + a.id + "', +" + i + ", 'M');\"" + ' title="' + s + '"><span class="ui-icon ui-icon-circle-triangle-' + (c ? "w" : "e") + '">' + s + "</span></a>" : e ? "" : '<a class="ui-datepicker-next ui-corner-all ui-state-disabled" title="' + s + '"><span class="ui-icon ui-icon-circle-triangle-' + (c ? "w" : "e") + '">' + s + "</span></a>",
                    u = this._get(a, "currentText"),
                    v = this._get(a, "gotoCurrent") && a.currentDay ? k : b;
            u = f ? this.formatDate(u, v, this._getFormatConfig(a)) : u;
            var w = a.inline ? "" : '<button type="button" class="ui-datepicker-close ui-state-default ui-priority-primary ui-corner-all" onclick="DP_jQuery_' + dpuuid + '.datepicker._hideDatepicker();">' + this._get(a, "closeText") + "</button>",
                    x = d ? '<div class="ui-datepicker-buttonpane ui-widget-content">' + (c ? w : "") + (this._isInRange(a, v) ? '<button type="button" class="ui-datepicker-current ui-state-default ui-priority-secondary ui-corner-all" onclick="DP_jQuery_' + dpuuid + ".datepicker._gotoToday('#" + a.id + "');\"" + ">" + u + "</button>" : "") + (c ? "" : w) + "</div>" : "",
                    y = parseInt(this._get(a, "firstDay"), 10);
            y = isNaN(y) ? 0 : y;
            var z = this._get(a, "showWeek"),
                    A = this._get(a, "dayNames"),
                    B = this._get(a, "dayNamesShort"),
                    C = this._get(a, "dayNamesMin"),
                    D = this._get(a, "monthNames"),
                    E = this._get(a, "monthNamesShort"),
                    F = this._get(a, "beforeShowDay"),
                    G = this._get(a, "showOtherMonths"),
                    H = this._get(a, "selectOtherMonths"),
                    I = this._get(a, "calculateWeek") || this.iso8601Week,
                    J = this._getDefaultDate(a),
                    K = "";
            for (var L = 0; L < g[0]; L++) {
                var M = "";
                this.maxRows = 4;
                for (var N = 0; N < g[1]; N++) {
                    var O = this._daylightSavingAdjust(new Date(o, n, a.selectedDay)),
                            P = " ui-corner-all",
                            Q = "";
                    if (j) {
                        Q += '<div class="ui-datepicker-group';
                        if (g[1] > 1) switch (N) {
                            case 0:
                                Q += " ui-datepicker-group-first", P = " ui-corner-" + (c ? "right" : "left");
                                break;
                            case g[1] - 1:
                                Q += " ui-datepicker-group-last", P = " ui-corner-" + (c ? "left" : "right");
                                break;
                            default:
                                Q += " ui-datepicker-group-middle", P = ""
                        }
                        Q += '">'
                    }
                    Q += '<div class="ui-datepicker-header ui-widget-header ui-helper-clearfix' + P + '">' + (/all|left/.test(P) && L == 0 ? c ? t : r : "") + (/all|right/.test(P) && L == 0 ? c ? r : t : "") + this._generateMonthYearHeader(a, n, o, l, m, L > 0 || N > 0, D, E) + '</div><table class="ui-datepicker-calendar"><thead>' + "<tr>";
                    var R = z ? '<th class="ui-datepicker-week-col">' + this._get(a, "weekHeader") + "</th>" : "";
                    for (var S = 0; S < 7; S++) {
                        var T = (S + y) % 7;
                        R += "<th" + ((S + y + 6) % 7 >= 5 ? ' class="ui-datepicker-week-end"' : "") + ">" + '<span title="' + A[T] + '">' + C[T] + "</span></th>"
                    }
                    Q += R + "</tr></thead><tbody>";
                    var U = this._getDaysInMonth(o, n);
                    o == a.selectedYear && n == a.selectedMonth && (a.selectedDay = Math.min(a.selectedDay, U));
                    var V = (this._getFirstDayOfMonth(o, n) - y + 7) % 7,
                            W = Math.ceil((V + U) / 7),
                            X = j ? this.maxRows > W ? this.maxRows : W : W;
                    this.maxRows = X;
                    var Y = this._daylightSavingAdjust(new Date(o, n, 1 - V));
                    for (var Z = 0; Z < X; Z++) {
                        Q += "<tr>";
                        var _ = z ? '<td class="ui-datepicker-week-col">' + this._get(a, "calculateWeek")(Y) + "</td>" : "";
                        for (var S = 0; S < 7; S++) {
                            var ba = F ? F.apply(a.input ? a.input[0] : null, [Y]) : [!0, ""],
                                    bb = Y.getMonth() != n,
                                    bc = bb && !H || !ba[0] || l && Y < l || m && Y > m;
                            _ += '<td class="' + ((S + y + 6) % 7 >= 5 ? " ui-datepicker-week-end" : "") + (bb ? " ui-datepicker-other-month" : "") + (Y.getTime() == O.getTime() && n == a.selectedMonth && a._keyEvent || J.getTime() == Y.getTime() && J.getTime() == O.getTime() ? " " + this._dayOverClass : "") + (bc ? " " + this._unselectableClass + " ui-state-disabled" : "") + (bb && !G ? "" : " " + ba[1] + (Y.getTime() == k.getTime() ? " " + this._currentClass : "") + (Y.getTime() == b.getTime() ? " ui-datepicker-today" : "")) + '"' + ((!bb || G) && ba[2] ? ' title="' + ba[2] + '"' : "") + (bc ? "" : ' onclick="DP_jQuery_' + dpuuid + ".datepicker._selectDay('#" + a.id + "'," + Y.getMonth() + "," + Y.getFullYear() + ', this);return false;"') + ">" + (bb && !G ? "&#xa0;" : bc ? '<span class="ui-state-default">' + Y.getDate() + "</span>" : '<a class="ui-state-default' + (Y.getTime() == b.getTime() ? " ui-state-highlight" : "") + (Y.getTime() == k.getTime() ? " ui-state-active" : "") + (bb ? " ui-priority-secondary" : "") + '" href="#">' + Y.getDate() + "</a>") + "</td>", Y.setDate(Y.getDate() + 1), Y = this._daylightSavingAdjust(Y)
                        }
                        Q += _ + "</tr>"
                    }
                    n++, n > 11 && (n = 0, o++), Q += "</tbody></table>" + (j ? "</div>" + (g[0] > 0 && N == g[1] - 1 ? '<div class="ui-datepicker-row-break"></div>' : "") : ""), M += Q
                }
                K += M
            }
            return K += x + ($.browser.msie && parseInt($.browser.version, 10) < 7 && !a.inline ? '<iframe src="javascript:false;" class="ui-datepicker-cover" frameborder="0"></iframe>' : ""), a._keyEvent = !1, K
        },
        _generateMonthYearHeader:function (a, b, c, d, e, f, g, h) {
            var i = this._get(a, "changeMonth"),
                    j = this._get(a, "changeYear"),
                    k = this._get(a, "showMonthAfterYear"),
                    l = '<div class="ui-datepicker-title">',
                    m = "";
            if (f || !i) m += '<span class="ui-datepicker-month">' + g[b] + "</span>";
            else {
                var n = d && d.getFullYear() == c,
                        o = e && e.getFullYear() == c;
                m += '<select class="ui-datepicker-month" onchange="DP_jQuery_' + dpuuid + ".datepicker._selectMonthYear('#" + a.id + "', this, 'M');\" " + ">";
                for (var p = 0; p < 12; p++)(!n || p >= d.getMonth()) && (!o || p <= e.getMonth()) && (m += '<option value="' + p + '"' + (p == b ? ' selected="selected"' : "") + ">" + h[p] + "</option>");
                m += "</select>"
            }
            k || (l += m + (f || !i || !j ? "&#xa0;" : ""));
            if (!a.yearshtml) {
                a.yearshtml = "";
                if (f || !j) l += '<span class="ui-datepicker-year">' + c + "</span>";
                else {
                    var q = this._get(a, "yearRange").split(":"),
                            r = (new Date).getFullYear(),
                            s = function (a) {
                                var b = a.match(/c[+-].*/) ? c + parseInt(a.substring(1), 10) : a.match(/[+-].*/) ? r + parseInt(a, 10) : parseInt(a, 10);
                                return isNaN(b) ? r : b
                            },
                            t = s(q[0]),
                            u = Math.max(t, s(q[1] || ""));
                    t = d ? Math.max(t, d.getFullYear()) : t, u = e ? Math.min(u, e.getFullYear()) : u, a.yearshtml += '<select class="ui-datepicker-year" onchange="DP_jQuery_' + dpuuid + ".datepicker._selectMonthYear('#" + a.id + "', this, 'Y');\" " + ">";
                    for (; t <= u; t++) a.yearshtml += '<option value="' + t + '"' + (t == c ? ' selected="selected"' : "") + ">" + t + "</option>";
                    a.yearshtml += "</select>", l += a.yearshtml, a.yearshtml = null
                }
            }
            return l += this._get(a, "yearSuffix"), k && (l += (f || !i || !j ? "&#xa0;" : "") + m), l += "</div>", l
        },
        _adjustInstDate:function (a, b, c) {
            var d = a.drawYear + (c == "Y" ? b : 0),
                    e = a.drawMonth + (c == "M" ? b : 0),
                    f = Math.min(a.selectedDay, this._getDaysInMonth(d, e)) + (c == "D" ? b : 0),
                    g = this._restrictMinMax(a, this._daylightSavingAdjust(new Date(d, e, f)));
            a.selectedDay = g.getDate(), a.drawMonth = a.selectedMonth = g.getMonth(), a.drawYear = a.selectedYear = g.getFullYear(), (c == "M" || c == "Y") && this._notifyChange(a)
        },
        _restrictMinMax:function (a, b) {
            var c = this._getMinMaxDate(a, "min"),
                    d = this._getMinMaxDate(a, "max"),
                    e = c && b < c ? c : b;
            return e = d && e > d ? d : e, e
        },
        _notifyChange:function (a) {
            var b = this._get(a, "onChangeMonthYear");
            b && b.apply(a.input ? a.input[0] : null, [a.selectedYear, a.selectedMonth + 1, a])
        },
        _getNumberOfMonths:function (a) {
            var b = this._get(a, "numberOfMonths");
            return b == null ? [1, 1] : typeof b == "number" ? [1, b] : b
        },
        _getMinMaxDate:function (a, b) {
            return this._determineDate(a, this._get(a, b + "Date"), null)
        },
        _getDaysInMonth:function (a, b) {
            return 32 - this._daylightSavingAdjust(new Date(a, b, 32)).getDate()
        },
        _getFirstDayOfMonth:function (a, b) {
            return (new Date(a, b, 1)).getDay()
        },
        _canAdjustMonth:function (a, b, c, d) {
            var e = this._getNumberOfMonths(a),
                    f = this._daylightSavingAdjust(new Date(c, d + (b < 0 ? b : e[0] * e[1]), 1));
            return b < 0 && f.setDate(this._getDaysInMonth(f.getFullYear(), f.getMonth())), this._isInRange(a, f)
        },
        _isInRange:function (a, b) {
            var c = this._getMinMaxDate(a, "min"),
                    d = this._getMinMaxDate(a, "max");
            return (!c || b.getTime() >= c.getTime()) && (!d || b.getTime() <= d.getTime())
        },
        _getFormatConfig:function (a) {
            var b = this._get(a, "shortYearCutoff");
            return b = typeof b != "string" ? b : (new Date).getFullYear() % 100 + parseInt(b, 10), {
                shortYearCutoff:b,
                dayNamesShort:this._get(a, "dayNamesShort"),
                dayNames:this._get(a, "dayNames"),
                monthNamesShort:this._get(a, "monthNamesShort"),
                monthNames:this._get(a, "monthNames")
            }
        },
        _formatDate:function (a, b, c, d) {
            b || (a.currentDay = a.selectedDay, a.currentMonth = a.selectedMonth, a.currentYear = a.selectedYear);
            var e = b ? typeof b == "object" ? b : this._daylightSavingAdjust(new Date(d, c, b)) : this._daylightSavingAdjust(new Date(a.currentYear, a.currentMonth, a.currentDay));
            return this.formatDate(this._get(a, "dateFormat"), e, this._getFormatConfig(a))
        }
    }), $.fn.datepicker = function (a) {
        if (!this.length) return this;
        $.datepicker.initialized || ($(document).mousedown($.datepicker._checkExternalClick).find("body").append($.datepicker.dpDiv), $.datepicker.initialized = !0);
        var b = Array.prototype.slice.call(arguments, 1);
        return typeof a != "string" || a != "isDisabled" && a != "getDate" && a != "widget" ? a == "option" && arguments.length == 2 && typeof arguments[1] == "string" ? $.datepicker["_" + a + "Datepicker"].apply($.datepicker, [this[0]].concat(b)) : this.each(function () {
            typeof a == "string" ? $.datepicker["_" + a + "Datepicker"].apply($.datepicker, [this].concat(b)) : $.datepicker._attachDatepicker(this, a)
        }) : $.datepicker["_" + a + "Datepicker"].apply($.datepicker, [this[0]].concat(b))
    }, $.datepicker = new Datepicker, $.datepicker.initialized = !1, $.datepicker.uuid = (new Date).getTime(), $.datepicker.version = "1.8.21", window["DP_jQuery_" + dpuuid] = $
})(jQuery);

/**
 * LastSeenArticle Collector
 *
 * Copyright (c) 2013, shopware AG
 */
;(function ( $, window, document, undefined ) {
    "use strict";

    var pluginName = 'lastSeenArticlesCollector',
        localStorage = window.localStorage,
        defaults = {
        };

    var format = function (str) {
        for (var i = 1; i < arguments.length; i++) {
            str = str.replace('%' + (i - 1), arguments[i]);
        }
        return str;
    };

    function Plugin( element, options ) {
        var me = this;

        me.element = element;
        me.options = $.extend( {}, defaults, options) ;
        me._defaults = defaults;
        me._name = pluginName;
        me.init();
    }

    Plugin.prototype.init = function () {
        var me = this,
            opts = me.options,
            articleNum = ~~(opts.numArticles),
            lastArticle = opts.lastArticles,
            index = localStorage.getItem('lastSeenArticleIndex-' + opts.shopId + '-' + opts.basePath) || 0,
            i = index - articleNum + 1,
            data,
            article,
            exists,
            url = lastArticle.linkDetailsRewrited;

        // Remove query string from article url
        if(url.indexOf('?') == -1) {
            // SEO URL does not exists
            if(url.indexOf('/sCategory') != -1) {
                lastArticle.linkDetailsRewrited = url.substring(0, url.indexOf('/sCategory'));
            }
        } else {
            lastArticle.linkDetailsRewrited = url.substring(0, url.indexOf('?'));
        }

        // Reset index if not defined
        if(index < 0) {
            index = 0;
        }

        for(; i < index + 1; i++) {
            data = localStorage.getItem('lastSeenArticle-' + opts.shopId + '-' + opts.basePath + i);

            if(!data) {
                continue;
            }

            article = JSON.parse(data);
            exists = (article.articleId == lastArticle.articleId);

            // break if the article exists already
            if(exists) {
                break;
            }
        }

        if(exists) {
            if(i != index) {
                // Delete existing article on old position
                localStorage.removeItem('lastSeenArticle-' + opts.shopId + '-' + opts.basePath + i);

                // Downgrading all articles with higher index
                var newIndex,
                    tmpData;

                for(var j = i + 1; j <= index; j++) {
                    newIndex = j - 1;
                    tmpData = localStorage.getItem('lastSeenArticle-' + opts.shopId + '-' + opts.basePath + j);
                    localStorage.removeItem('lastSeenArticle-' + opts.shopId + '-' + opts.basePath + j);
                    localStorage.setItem('lastSeenArticle-' + opts.shopId + '-' + opts.basePath + newIndex, tmpData);
                }

                // Adding this article on top index
                localStorage.setItem('lastSeenArticle-' + opts.shopId + '-' + opts.basePath + index, JSON.stringify(opts.lastArticles));
            }
            return false;
        }

        localStorage.setItem('lastSeenArticleIndex-' + opts.shopId + '-' + opts.basePath, ++index);
        localStorage.setItem('lastSeenArticle-' + opts.shopId + '-' + opts.basePath + index, JSON.stringify(opts.lastArticles));
        localStorage.removeItem('lastSeenArticle-' + opts.shopId + '-' + opts.basePath + (index - articleNum));
    };

    $(document).ready(function() {
        if(!$.isLocalStorageSupported) {
            localStorage = new StoragePolyFill('local');
        }

        $.fn[pluginName] = function ( options ) {
            return this.each(function () {
                if (!$.data(this, 'plugin_' + pluginName)) {
                    $.data(this, 'plugin_' + pluginName,
                        new Plugin( this, options ));
                }
            });
        }
    });
})( jQuery, window, document );

/**
 * LastSeenArticle Displayer
 *
 * Copyright (c) 2013, shopware AG
 */
;(function ( $, window, document, undefined ) {
    "use strict";

    var pluginName = 'lastSeenArticlesDisplayer',
        localStorage = window.localStorage,
        defaults = {
        };

    // Append articles to Template
    var createTemplate = function(article, lastClass) {
        var rule, image, hidden, desc;

        if(!article) {
            return false;
        }

        rule = $('<li>', { 'class': 'lastview_rule' + lastClass });
        image = $('<a>', {
            'id': article['articleId'],
            'rel': 'nofollow',
            'class': 'article_image',
            'href': article['linkDetailsRewrited'],
            'style': 'background: #fff url(' + article['thumbnail'] + ') no-repeat center center'

        });

        hidden = $('<span>', {
            'class': 'hidden',
            'html': article['articleName']
        });

        desc = $('<a>', {
            'rel': 'nofollow',
            'class': 'article_description',
            'title': article['articleName'],
            'href': article['linkDetailsRewrited'],
            'html': article['articleName']
        });

        hidden.appendTo(image);
        image.appendTo(rule);
        hidden.appendTo(rule);
        desc.appendTo(rule);
        return rule;
    };

    function Plugin( element, options ) {
        this.element = element;
        this.options = $.extend( {}, defaults, options);
        this._defaults = defaults;
        this._name = pluginName;
        this.init(options);
    }

    Plugin.prototype.init = function (options) {
        // Plugin configuration
        var articleNum = options.numArticles,
            shopId = options.shopId,
            basePath = options.basePath,
            index = localStorage.getItem('lastSeenArticleIndex-' + shopId + '-' + basePath),
            i = 1,
            lastClass = '',
            data, article, all;

        if(!articleNum) articleNum = 5;
        all = index;

        // Append all articles to the template
        for(; i <= all; i++) {
            if(localStorage.getItem('lastSeenArticle-' + shopId + '-' + basePath + index))
            {
                data = localStorage.getItem('lastSeenArticle-' + shopId + '-' + basePath + index);
                article = JSON.parse(data);
                lastClass = '';
                if(i == all || i % 5 == 0) lastClass = '_last';

                // Check if its emotion or default template
                if($('.viewlast ul').length)
                {
                    $('.viewlast ul').append(createTemplate(article, lastClass));
                }
                else
                {
                    $('.viewlast').append(createTemplate(article, lastClass));
                }
            }
            index = index -1;
        }
    };

    $(document).ready(function() {
        if(!$.isLocalStorageSupported) {
            localStorage = new StoragePolyFill('local');
        }

        $.fn[pluginName] = function ( options ) {
            return this.each(function () {
                if (!$.data(this, 'plugin_' + pluginName)) {
                    $.data(this, 'plugin_' + pluginName,
                        new Plugin( this, options ));
                }
            });
        }
    });
})(jQuery, window, document);

/**
 * JSON polyfill which provides support for <= IE7
 *
 * @author: Douglas Crockford
 * @link: https://github.com/douglascrockford/JSON-js/blob/master/json2.js
 */
if (navigator.appVersion.indexOf("MSIE 7.") != -1)
{
    if (typeof JSON !== 'object') {
        JSON = {};
    }

    (function () {
        'use strict';

        function f(n) {
            // Format integers to have at least two digits.
            return n < 10 ? '0' + n : n;
        }

        if (typeof Date.prototype.toJSON !== 'function') {

            String.prototype.toJSON =
                Number.prototype.toJSON =
                    Boolean.prototype.toJSON = function () {
                        return this.valueOf();
                    };
        }

        var cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
            escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
            gap,
            indent,
            meta = { // table of character substitutions
                '\b': '\\b',
                '\t': '\\t',
                '\n': '\\n',
                '\f': '\\f',
                '\r': '\\r',
                '"' : '\\"',
                '\\': '\\\\'
            },
            rep;

        function quote(string) {

            escapable.lastIndex = 0;
            return escapable.test(string) ? '"' + string.replace(escapable, function (a) {
                var c = meta[a];
                return typeof c === 'string'
                    ? c
                    : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
            }) + '"' : '"' + string + '"';
        }

        function str(key, holder) {

            var i, // The loop counter.
                k, // The member key.
                v, // The member value.
                length,
                mind = gap,
                partial,
                value = holder[key];

            if (value && typeof value === 'object' &&
                typeof value.toJSON === 'function') {
                value = value.toJSON(key);
            }

            if (typeof rep === 'function') {
                value = rep.call(holder, key, value);
            }

            switch (typeof value) {
                case 'string':
                    return quote(value);

                case 'number':

                    return isFinite(value) ? String(value) : 'null';

                case 'boolean':
                case 'null':

                    return String(value);

                case 'object':

                    if (!value) {
                        return 'null';
                    }

                    gap += indent;
                    partial = [];

                    if (Object.prototype.toString.apply(value) === '[object Array]') {

                        length = value.length;
                        for (i = 0; i < length; i += 1) {
                            partial[i] = str(i, value) || 'null';
                        }

                        v = partial.length === 0
                            ? '[]'
                            : gap
                            ? '[\n' + gap + partial.join(',\n' + gap) + '\n' + mind + ']'
                            : '[' + partial.join(',') + ']';
                        gap = mind;
                        return v;
                    }

                    if (rep && typeof rep === 'object') {
                        length = rep.length;
                        for (i = 0; i < length; i += 1) {
                            if (typeof rep[i] === 'string') {
                                k = rep[i];
                                v = str(k, value);
                                if (v) {
                                    partial.push(quote(k) + (gap ? ': ' : ':') + v);
                                }
                            }
                        }
                    } else {

                        for (k in value) {
                            if (Object.prototype.hasOwnProperty.call(value, k)) {
                                v = str(k, value);
                                if (v) {
                                    partial.push(quote(k) + (gap ? ': ' : ':') + v);
                                }
                            }
                        }
                    }

                    v = partial.length === 0
                        ? '{}'
                        : gap
                        ? '{\n' + gap + partial.join(',\n' + gap) + '\n' + mind + '}'
                        : '{' + partial.join(',') + '}';
                    gap = mind;
                    return v;
            }
        }

        if (typeof JSON.stringify !== 'function') {
            JSON.stringify = function (value, replacer, space) {

                var i;
                gap = '';
                indent = '';


                if (typeof space === 'number') {
                    for (i = 0; i < space; i += 1) {
                        indent += ' ';
                    }

                } else if (typeof space === 'string') {
                    indent = space;
                }

                rep = replacer;
                if (replacer && typeof replacer !== 'function' &&
                    (typeof replacer !== 'object' ||
                        typeof replacer.length !== 'number')) {
                    throw new Error('JSON.stringify');
                }

                return str('', {'': value});
            };
        }

        if (typeof JSON.parse !== 'function') {
            JSON.parse = function (text, reviver) {

                var j;

                function walk(holder, key) {

                    var k, v, value = holder[key];
                    if (value && typeof value === 'object') {
                        for (k in value) {
                            if (Object.prototype.hasOwnProperty.call(value, k)) {
                                v = walk(value, k);
                                if (v !== undefined) {
                                    value[k] = v;
                                } else {
                                    delete value[k];
                                }
                            }
                        }
                    }
                    return reviver.call(holder, key, value);
                }

                text = String(text);
                cx.lastIndex = 0;
                if (cx.test(text)) {
                    text = text.replace(cx, function (a) {
                        return '\\u' +
                            ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
                    });
                }

                if (/^[\],:{}\s]*$/
                    .test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@')
                        .replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']')
                        .replace(/(?:^|:|,)(?:\s*\[)+/g, ''))) {

                    j = eval('(' + text + ')');

                    return typeof reviver === 'function'
                        ? walk({'': j}, '')
                        : j;
                }

                throw new SyntaxError('JSON.parse');
            };
        }
    }());
}

/**
 * localStorage polyfill which provides support for < IE7 using a cookie.
 *
 * @author: Remy Sharp
 * @license: MIT http://rem.mit-license.org/
 * @link: https://gist.github.com/remy/350433
 */
(function ($, window, document, undefined) {
    window.StoragePolyFill = function (type) {
        function createCookie(name, value, days) {
            var date,
                expires = '';

            if (days) {
                date = new Date();
                date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
                expires = '; expires=' + date.toGMTString();
            }

            value = encodeURI(value);

            document.cookie = name + '=' + value + expires + '; path=/';
        }

        function readCookie(name) {
            var nameEQ = name + '=',
                ca = document.cookie.split(';'),
                i, c;

            for (i = 0; i < ca.length; i++) {
                c = ca[i];
                while (c.charAt(0) == ' ') {
                    c = c.substring(1, c.length);
                }

                if (c.indexOf(nameEQ) == 0) {
                    return decodeURI(c.substring(nameEQ.length, c.length));
                }
            }
            return null;
        }
        function setData(data) {
            data = JSON.stringify(data);
            if (type == 'session') {
                createCookie('sessionStorage', data, 0);
            } else {
                createCookie('localStorage', data, 365);
            }
        }
        function clearData() {
            if (type == 'session') {
                createCookie('sessionStorage', '', 0);
            } else {
                createCookie('localStorage', '', 365);
            }
        }
        function getData() {
            var data = type == 'session' ? readCookie('sessionStorage') : readCookie('localStorage');
            return data ? JSON.parse(data) : {};
        }

        // initialise if there's already data
        var data = getData();

        return {
            length: 0,
            clear: function () {
                data = {};
                this.length = 0;
                clearData();
            },
            getItem: function (key) {
                return data[key] === undefined ? null : data[key];
            },
            key: function (i) {
                // not perfect, but works
                var ctr = 0;
                for (var k in data) {
                    if (ctr == i) return k;
                    else ctr++;
                }
                return null;
            },
            removeItem: function (key) {
                delete data[key];
                this.length--;
                setData(data);
            },
            setItem: function (key, value) {
                data[key] = value+''; // forces the value to a string
                this.length++;
                setData(data);
            }
        };
    };

    if (typeof window.localStorage == 'undefined') window.localStorage = new StoragePolyFill('local');
    if (typeof window.sessionStorage == 'undefined') window.sessionStorage = new StoragePolyFill('session');

    /**
     * Returns whether or not the given storage is available and works - SW-7524
     *
     * @returns { boolean }
     */
    function isStorageSupported (storage) {
        var testKey = 'test';

        if (!storage) {
            return false;
        }

        try {
            storage.setItem(testKey, '1');
            storage.removeItem(testKey);
            return true;
        } catch (error) {
            return false;
        }
    }

    $.extend($, {
        isLocalStorageSupported: isStorageSupported(window.localStorage),
        isSessionStorageSupported: isStorageSupported(window.sessionStorage)
    });

})(jQuery, window, document);
